package com.ync365.jrpt.business.dao;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import com.ync365.jrpt.business.dao.entity.JnzProductAgreement;


/**
 * <b>功能描述：产品合同Dao
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzProductAgreementDao {
	/**
	 * <b>功能描述：查询产品合同列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzProductAgreementByList(Map map); 
	/**
	 * <b>功能描述：查询产品合同列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzProductAgreementByCount(Map map); 
	/**
	 * <b>功能描述：根据ID查询产品合同信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzProductAgreementById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：根据ID删除产品合同
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzProductAgreementById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：修改产品合同
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzProductAgreementBySelective(JnzProductAgreement jnzProductAgreement);
	/**
	 * <b>功能描述：新增产品合同
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzProductAgreementSelective(JnzProductAgreement jnzProductAgreement);
	/**
	 * <b>功能描述：新增产品合同
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzProductAgreement(JnzProductAgreement jnzProductAgreement);
	
	    /**
     * 
     * 功能描述: 批量删除产品合同
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchDeleteJnzProductAgreement(Map<String, Object> paraMap);
}
