package com.ync365.jrpt.business.dao;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import com.ync365.jrpt.business.dao.entity.JnzPartner;


/**
 * <b>功能描述：合作伙伴Dao
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzPartnerDao {
	/**
	 * <b>功能描述：查询合作伙伴列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzPartnerByList(Map map); 
	/**
	 * <b>功能描述：查询合作伙伴列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzPartnerByCount(Map map); 
	/**
	 * <b>功能描述：根据ID查询合作伙伴信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzPartnerById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：根据ID删除合作伙伴
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzPartnerById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：修改合作伙伴
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzPartnerBySelective(JnzPartner jnzPartner);
	/**
	 * <b>功能描述：新增合作伙伴
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzPartnerSelective(JnzPartner jnzPartner);
	/**
	 * <b>功能描述：新增合作伙伴
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzPartner(JnzPartner jnzPartner);
	
	    /**
     * 
     * 功能描述: 批量删除合作伙伴
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchDeleteJnzPartner(Map<String, Object> paraMap);
}
