package com.ync365.jrpt.business.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.ync365.jrpt.business.dao.entity.BasicBankInfo;


/**
 * <b>功能描述：银行基础信息Dao
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface BasicBankInfoDao {
	/**
	 * <b>功能描述：查询银行基础信息列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryBasicBankInfoByList(Map map); 
	/**
	 * <b>功能描述：查询银行基础信息列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryBasicBankInfoByCount(Map map); 
	/**
	 * <b>功能描述：根据ID查询银行基础信息信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryBasicBankInfoById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：根据ID删除银行基础信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteBasicBankInfoById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：修改银行基础信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateBasicBankInfoBySelective(BasicBankInfo basicBankInfo);
	/**
	 * <b>功能描述：新增银行基础信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertBasicBankInfoSelective(BasicBankInfo basicBankInfo);
	/**
	 * <b>功能描述：新增银行基础信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertBasicBankInfo(BasicBankInfo basicBankInfo);
	
	    /**
     * 
     * 功能描述: 批量删除银行基础信息
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchDeleteBasicBankInfo(Map<String, Object> paraMap);
    /**
     * 
     * 功能描述: 根据银行卡号获取所属银行
     * 
     * @param cardNo
     * @return BasicBankInfo
     * @version 1.0.0
     * @author 徐大伟
     */
    public BasicBankInfo getBankByCardNo(@Param("cardNo")String cardNo);
}
