package com.ync365.jrpt.business.dao;

import com.ync365.jrpt.business.dao.entity.Areas;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 区域
 */
public interface AreasDao
{

    int deleteByPrimaryKey(String id);

    int insert(Areas record);

    int insertSelective(Areas record);

    Areas selectByPrimaryKey(String id);

    int updateByPrimaryKeySelective(Areas record);

    int updateByPrimaryKey(Areas record);

    /**
     * 根据层级和地区父级ID查找地区信息
     *
     * @param level
     * @param parentId
     * @return
     */
    List<Areas> findAreasByLevelAndParentId(@Param("level") Integer level, @Param("parentId") String parentId);
    
    /**
     * 根据子节点查询自己以及自己所有的上级节点
     * 
     * @param childrenId 
     * @return 
     */
    List<Areas> findAllParentAreasByChild(@Param("areaCode") String childrenId);

}
