package com.ync365.jrpt.business.biz;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.TableInfoDao;
import com.ync365.jrpt.business.dao.entity.TableInfo;

/**
 * <b>功能描述：表结构信息Biz
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("tableInfoBiz")
public class  TableInfoBiz {

	private final static Logger logger= Logger.getLogger(TableInfoBiz.class);
	
	@Autowired
	private TableInfoDao tableInfoDao;

	
	private List<TableInfo> findAllFieldsInfo(String tableName){
		return tableInfoDao.findAllFieldsInfo(tableName);
	}
	
	private TableInfo findFieldInfoByField(String tableName,String fieldName){
		return tableInfoDao.findFieldInfoByField(tableName, fieldName);
	}
	 
	/**
	 * <b>功能描述：查询产品表结构信息
	 * @return
	 */
	public List<TableInfo> getProductInfoTable(){
		return findAllFieldsInfo("jnz_product_info");
	}
	
	/**
	 * <b>功能描述：查询产品表指定字段信息
	 * @param fieldName
	 * @return
	 */
	public TableInfo getProductInfoByField(String fieldName){
		return findFieldInfoByField("jnz_product_info", fieldName);
	}
}
