package com.ync365.jrpt.business.biz;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.PositionDao;
import com.ync365.jrpt.business.dao.entity.JnzPosition;
import com.ync365.jrpt.business.dao.entity.Position;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

@Service
public class PositionBiz extends BaseBiz {
	
	@Autowired
	private PositionDao positionDao;
	/**
	 * 查询所有位置
	 * @return
	 */
	public List<Position> selectAll(){
		return positionDao.selectAll();
	}

	public List<Map<String, Object>> selectedCheck(Integer sid){
		return positionDao.selectedCheck(sid);
	}
	
	/**
	 * 分页查询
	 * @param position
	 * @param pageRequest
	 * @return
	 */
	public Page<Map<String, Object>> findPositionByPage(Position position,PageRequest pageRequest) {
		List<Map<String, Object>> list = findPositionByList( position, pageRequest);
	    int total = findPositionByCount(position);
		return PageBuilder.buildPage(pageRequest, list, total);
	}
	/**
	 * 查询列表
	 * @param position
	 * @param pageRequest
	 * @return
	 */
	public List<Map<String, Object>> findPositionByList(Position position,PageRequest pageRequest) {
		 	Map<String, Object> map = new HashMap<String, Object>();
	        map.put("name", position.getName());
	        map.put("positionType", position.getPositionType());
	        map.put("status", position.getStatus());
	        map.put("clientType", position.getClientType());
	        map.put("offset", pageRequest.getOffset());
	        map.put("limit", pageRequest.getPageSize());
		return positionDao.findPositionList(map);
	}
	
	/**
	 * 
	 * 功能描述: 查询所有位置信息
	 * 
	 * @param position
	 * @param pageRequest
	 * @return List<Map<String,Object>>
	 * @version 1.0.0
	 * @author 徐大伟
	 */
	public List<Map<String, Object>> findPositionByList(Position position) {
           Map<String, Object> map = new HashMap<String, Object>();
           map.put("name", position.getName());
           map.put("positionType", position.getPositionType());
           map.put("status", position.getStatus());
           map.put("clientType", position.getClientType());
       return positionDao.findPositionList(map);
   }
	
	/**
	 * 
	 * 功能描述: 统计
	 * 
	 * @param position
	 * @return Integer
	 * @date 2016-11-9
	 * @since 1.0.0
	 * @version 1.0.0
	 * @author 徐大伟
	 */
	public Integer findPositionByCount(Position position) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("name", position.getName());
		map.put("positionType", position.getPositionType());
		map.put("status", position.getStatus());
		map.put("clientType", position.getClientType());
		return positionDao.findPositionByCount(map);
	}

	public boolean power(Integer id, Integer status) {
		return positionDao.power( id,  status)>0?true:false;
	}
	/**
	 * 
	 * 功能描述: 获取手机端栏目开关状态
	 * 
	 * @return List<JnzPosition>
	 * @date 2016-11-9
	 * @since 1.0.0
	 * @version 1.0.0
	 * @author 徐大伟
	 */
    public List<JnzPosition> getAppPositionList() {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("status", "1");
        map.put("clientType", "2");
        return positionDao.getAppPositionList(map);
    }
}
