package com.ync365.jrpt.business.biz;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.JobLogDao;
import com.ync365.jrpt.business.dao.entity.JobLog;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

/**
 * 
 * 功能描述:job日志 
 * 
 * @version 1.0.0
 * @author 徐大伟
 */
@Service("jobLogBiz")
public class JobLogBiz extends BaseBiz {
    @Autowired
    private JobLogDao jobLogDao;
    /**
     * 
     * 功能描述: 添加job日志
     * @param jobLog
     * @return Long 成功数量
     * @version 1.0.0
     * @author 徐大伟
     */
    public Long addJobLog(JobLog jobLog) {
        Long num=0L;
        try {
            num=(long) jobLogDao.insertSelective(jobLog);
        } catch (Exception e) {
            logger.info(e.getMessage(),e);
        }
        logger.info("the jobLog is insert and this success number is [{}]",num);
        return num;
    }
    /**
     * 
     * 功能描述: 查看joblog列表
     * 
     * @param pageRequest 分页参数
     * @return Page<Map<String,Object>>
     * @version 1.0.0
     * @author 王佳田
     */
    public Page<Map<String, Object>> selectJobLog(PageRequest pageRequest){
        Map map = new HashMap();
        //封装分页参数
        map.put("offset", pageRequest.getOffset());
        map.put("limit", pageRequest.getPageSize());
        //查询结果集
        List<Map<String, Object>> resultList = jobLogDao.selectAllWithPage(map);
        //查询总数量
        Integer count = jobLogDao.selectAllWithPageCount(map);
        //返回结果
        return PageBuilder.buildPage(pageRequest, resultList, count);
    }
}
