package com.ync365.jrpt.business.biz;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import org.apache.ibatis.annotations.Param;

import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;
import com.ync365.jrpt.business.dao.JnzVersionDao;
import com.ync365.jrpt.business.dao.entity.JnzVersion;
import com.ync365.jrpt.util.BeanMapper;

/**
 * <b>功能描述：系统版本Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzVersionBiz")
public class  JnzVersionBiz {

  private final static Logger logger= Logger.getLogger(JnzVersionBiz.class);
	

	@Autowired
    private JnzVersionDao jnzVersionDao;

		/**
	 * <b>功能描述：查询系统版本列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzVersionByList(JnzVersion jnzVersion,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzVersion",jnzVersion);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzVersionDao.queryJnzVersionByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询系统版本列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzVersionByCount(JnzVersion jnzVersion){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzVersion",jnzVersion);
		return jnzVersionDao.queryJnzVersionByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询系统版本信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzVersionById(Integer id){
		return jnzVersionDao.queryJnzVersionById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除系统版本
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzVersionById(Integer id){
		return jnzVersionDao.deleteJnzVersionById(id);
	} 
	/**
	 * <b>功能描述：修改系统版本
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzVersionBySelective(JnzVersion jnzVersion){
		return jnzVersionDao.updateJnzVersionBySelective(jnzVersion);
	}
	/**
	 * <b>功能描述：新增系统版本
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzVersionSelective(JnzVersion jnzVersion){
		return 	jnzVersionDao.insertJnzVersionSelective(jnzVersion);
	}
	/**
	 * <b>功能描述：新增系统版本
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzVersion(JnzVersion jnzVersion){
		return 	jnzVersionDao.insertJnzVersion(jnzVersion);
	}
	 /**
     * 
     * 功能描述: 分页查询系统版本
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzVersionListByPage(JnzVersion jnzVersion,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzVersionByList(jnzVersion,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzVersionByCount(jnzVersion);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除系统版本
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzVersion(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzVersionDao.batchDeleteJnzVersion(paraMap);
	    return r1;
	}
	 /**
	  * 
	  * 功能描述: 获取最新系统版本
	  * 
	  * @param ids
	  * @return int
    * @version V1.0.0
    * @author 徐大伟
	  */
	public com.ync365.jrpt.business.dao.entity.JnzVersion getNewestVersion() {
		JnzVersion  JnzVersion = new JnzVersion();
		JnzVersion.setVersionType(1);
		List<Map<String, Object>> list = queryJnzVersionByList(JnzVersion,"id desc",1,1);
		JnzVersion  jnzVersion  = BeanMapper.map(list.get(0), JnzVersion.class);
		return jnzVersion;
	}
}
