package com.ync365.jrpt.business.biz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.JnzProductInfoDao;
import com.ync365.jrpt.business.dao.JnzUserInfoDao;
import com.ync365.jrpt.business.dao.JnzUserTradeOrderDao;
import com.ync365.jrpt.business.dao.entity.JnzProductInfo;
import com.ync365.jrpt.business.dao.entity.JnzUserInfo;
import com.ync365.jrpt.business.dao.entity.JnzUserTradeOrder;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

/**
 * <b>功能描述：交易订单Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzUserTradeOrderBiz")
public class  JnzUserTradeOrderBiz {

  private final static Logger logger= Logger.getLogger(JnzUserTradeOrderBiz.class);
	

	@Autowired
    private JnzUserTradeOrderDao jnzUserTradeOrderDao;
	
	@Autowired
	private JnzUserInfoDao jnzUserInfoDao;
	
	@Autowired
	private JnzProductInfoDao jnzProductInfoDao;

		/**
	 * <b>功能描述：查询交易订单列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzUserTradeOrderByList(JnzUserTradeOrder jnzUserTradeOrder,JnzProductInfo jnzProductInfo,JnzUserInfo jnzUserInfo,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzUserInfo", jnzUserInfo);
        paraMap.put("jnzProductInfo", jnzProductInfo);
        paraMap.put("jnzUserTradeOrder",jnzUserTradeOrder);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
        List<Map<String,Object>> list = jnzUserTradeOrderDao.queryJnzUserTradeOrderByList(paraMap);
        /*// 将用户信息拼接进去
        if(list != null && list.size() >0){
        	for (Map<String, Object> map : list) {
        		Integer userId = MapUtils.getInteger(map, "userId");
        		if(null != userId){
        			Map<String, Object> userMap = 	jnzUserInfoDao.queryJnzUserInfoById(userId);
        			if(null != userMap){
        				map.put("userPhone", userMap.get("userPhone"));
        			}
        		}
        		Integer productId = MapUtils.getInteger(map, "productId");
        		if(null != productId){
        			Map<String, Object> userMap = 	jnzProductInfoDao.queryJnzProductInfoById(productId);
        			if(null != userMap){
        				map.put("productType", userMap.get("productType"));
        				map.put("productName", userMap.get("productName"));
        			}
        		}
			}
        }*/
		return list;
	} 
	/**
	 * 
	 * 功能描述: 查询订单带有产品信息
	 * 
	 * @param userId
	 * @param type
	 * @param pageNo
	 * @param pageSize
	 * @return List<Map<String,Object>>
	 * @version 1.0.0
	 * @author 王佳田
	 */
	public List<Map<String,Object>> queryUserOrderWithProduct(Integer userId, Integer type,int pageNo,int pageSize){
        String limitClause ="";
        if(pageNo !=0 && pageSize != 0){
            limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
        }
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("userId",userId);
        paraMap.put("type",type);
        paraMap.put("limitClause",limitClause);
        List<Map<String,Object>> list = jnzUserTradeOrderDao.queryUserOrderWithProduct(paraMap);
        return list;
    } 
	
	/**
	 * <b>功能描述：查询交易订单列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzUserTradeOrderByCount(JnzUserTradeOrder jnzUserTradeOrder,JnzProductInfo jnzProductInfo,JnzUserInfo jnzUserInfo){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("jnzUserInfo", jnzUserInfo);
        paraMap.put("jnzUserTradeOrder",jnzUserTradeOrder);
        paraMap.put("jnzProductInfo", jnzProductInfo);
		return jnzUserTradeOrderDao.queryJnzUserTradeOrderByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询交易订单信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzUserTradeOrderById(Integer id){
		return jnzUserTradeOrderDao.queryJnzUserTradeOrderById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除交易订单
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzUserTradeOrderById(Integer id){
		return jnzUserTradeOrderDao.deleteJnzUserTradeOrderById(id);
	} 
	/**
	 * <b>功能描述：修改交易订单
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzUserTradeOrderBySelective(JnzUserTradeOrder jnzUserTradeOrder){
		return jnzUserTradeOrderDao.updateJnzUserTradeOrderBySelective(jnzUserTradeOrder);
	}
	/**
	 * <b>功能描述：新增交易订单
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserTradeOrderSelective(JnzUserTradeOrder jnzUserTradeOrder){
		return 	jnzUserTradeOrderDao.insertJnzUserTradeOrderSelective(jnzUserTradeOrder);
	}
	/**
	 * <b>功能描述：新增交易订单
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserTradeOrder(JnzUserTradeOrder jnzUserTradeOrder){
		return 	jnzUserTradeOrderDao.insertJnzUserTradeOrder(jnzUserTradeOrder);
	}
	 /**
     * 
     * 功能描述: 分页查询交易订单
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzUserTradeOrderListByPage(JnzUserTradeOrder jnzUserTradeOrder,JnzProductInfo jnzProductInfo,JnzUserInfo jnzUserInfo,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzUserTradeOrderByList(jnzUserTradeOrder,jnzProductInfo,jnzUserInfo,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzUserTradeOrderByCount(jnzUserTradeOrder,jnzProductInfo,jnzUserInfo);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除交易订单
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzUserTradeOrder(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzUserTradeOrderDao.batchDeleteJnzUserTradeOrder(paraMap);
	    return r1;
	}
	
	public List<Map<String, Object>> queryUserSavingStatics(String year){
		return jnzUserTradeOrderDao.queryUserSavingStatics(year);
	}
	
}
