package com.ync365.jrpt.business.biz;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.JnzUserTradeLogDao;
import com.ync365.jrpt.business.dao.entity.JnzUserTradeLog;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

/**
 * <b>功能描述：交易日志Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzUserTradeLogBiz")
public class  JnzUserTradeLogBiz {

  private final static Logger logger= Logger.getLogger(JnzUserTradeLogBiz.class);
	

	@Autowired
    private JnzUserTradeLogDao jnzUserTradeLogDao;

		/**
	 * <b>功能描述：查询交易日志列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzUserTradeLogByList(JnzUserTradeLog jnzUserTradeLog,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzUserTradeLog",jnzUserTradeLog);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzUserTradeLogDao.queryJnzUserTradeLogByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询交易日志列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzUserTradeLogByCount(JnzUserTradeLog jnzUserTradeLog){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzUserTradeLog",jnzUserTradeLog);
		return jnzUserTradeLogDao.queryJnzUserTradeLogByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询交易日志信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzUserTradeLogById(Integer id){
		return jnzUserTradeLogDao.queryJnzUserTradeLogById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除交易日志
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzUserTradeLogById(Integer id){
		return jnzUserTradeLogDao.deleteJnzUserTradeLogById(id);
	} 
	/**
	 * <b>功能描述：修改交易日志
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzUserTradeLogBySelective(JnzUserTradeLog jnzUserTradeLog){
		return jnzUserTradeLogDao.updateJnzUserTradeLogBySelective(jnzUserTradeLog);
	}
	/**
	 * <b>功能描述：新增交易日志
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserTradeLogSelective(JnzUserTradeLog jnzUserTradeLog){
		return 	jnzUserTradeLogDao.insertJnzUserTradeLogSelective(jnzUserTradeLog);
	}
	/**
	 * <b>功能描述：新增交易日志
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserTradeLog(JnzUserTradeLog jnzUserTradeLog){
		return 	jnzUserTradeLogDao.insertJnzUserTradeLog(jnzUserTradeLog);
	}
	 /**
     * 
     * 功能描述: 分页查询交易日志
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzUserTradeLogListByPage(JnzUserTradeLog jnzUserTradeLog,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzUserTradeLogByList(jnzUserTradeLog,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzUserTradeLogByCount(jnzUserTradeLog);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除交易日志
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzUserTradeLog(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzUserTradeLogDao.batchDeleteJnzUserTradeLog(paraMap);
	    return r1;
	}
	
	/**
	 * 
	 * 功能描述: 查询昨日收益
	 * 
	 * @param userId
	 * @return BigDecimal
	 * @version 1.0.0
	 * @author 王佳田
	 */
	public BigDecimal findUserYesterdayProfit(Integer userId){
	    BigDecimal bigDecimal =  jnzUserTradeLogDao.findUserYesterdayProfit(userId) ;
	    return bigDecimal == null ? new BigDecimal(0):bigDecimal;
	}
	/**
	 * 
	 * 功能描述: 查询本月回款总额
	 * 
	 * @param userId
	 * @return BigDecimal
	 * @version 1.0.0
	 * @author 王佳田
	 */
	public BigDecimal findUserMothPayment(Integer userId){
        BigDecimal bigDecimal =  jnzUserTradeLogDao.findUserMothPayment(userId) ;
        return bigDecimal == null ? new BigDecimal(0):bigDecimal;
    }
}
