package com.ync365.jrpt.business.biz;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ync365.jrpt.business.dao.JnzUserAssetDao;
import com.ync365.jrpt.business.dao.JnzUserInfoDao;
import com.ync365.jrpt.business.dao.entity.JnzUserAsset;
import com.ync365.jrpt.business.dao.entity.JnzUserInfo;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;
import com.ync365.jrpt.util.DateUtil;
import com.ync365.jrpt.util.EncryptUtil;
import com.ync365.jrpt.util.StringUtil;

/**
 * <b>功能描述：用户信息Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzUserInfoBiz")
public class  JnzUserInfoBiz extends BaseBiz {

  private final static Logger logger= Logger.getLogger(JnzUserInfoBiz.class);
	

	@Autowired
    private JnzUserInfoDao jnzUserInfoDao;
	
	@Autowired
	private JnzUserAssetDao jnzUserAssetDao;

		/**
	 * <b>功能描述：查询用户信息列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzUserInfoByList(JnzUserInfo jnzUserInfo,String orderByClause,int pageNo,int pageSize,String startDate,String endDate){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzUserInfo",jnzUserInfo);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
        if (StringUtil.isEmpty(startDate)) {
			paraMap.put("startDate", startDate);
		}else {
			paraMap.put("startDate",DateUtil.buildMinOfDate(DateUtil.str2Date(startDate)));
		}
        if (StringUtil.isEmpty(endDate)) {
        	paraMap.put("endDate", endDate);
		}else {
			paraMap.put("endDate",DateUtil.buildMaxOfDate(DateUtil.str2Date(endDate)));
		}
		return jnzUserInfoDao.queryJnzUserInfoByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询用户信息列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzUserInfoByCount(JnzUserInfo jnzUserInfo,String startDate,String endDate){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzUserInfo",jnzUserInfo);
        if (StringUtil.isEmpty(startDate)) {
        	paraMap.put("startDate",startDate);
		}else {
			paraMap.put("startDate",DateUtil.buildMinOfDate(DateUtil.str2Date(startDate)));
		}
        if (StringUtil.isEmpty(endDate)) {
        	paraMap.put("endDate",endDate);
		}else {
			paraMap.put("endDate",DateUtil.buildMinOfDate(DateUtil.str2Date(endDate)));
		}
		return jnzUserInfoDao.queryJnzUserInfoByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询用户信息信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzUserInfoById(Integer id){
		return jnzUserInfoDao.queryJnzUserInfoById(id);
	} 
	public JnzUserInfo  queryJnzUserInfoByUserId(Integer userId){
	    return jnzUserInfoDao.queryJnzUserInfoByUserId(userId);
	} 
	/**
	 * <b>功能描述：根据ID删除用户信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzUserInfoById(Integer id){
		return jnzUserInfoDao.deleteJnzUserInfoById(id);
	} 
	/**
	 * <b>功能描述：修改用户信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzUserInfoBySelective(JnzUserInfo jnzUserInfo){
		return jnzUserInfoDao.updateJnzUserInfoBySelective(jnzUserInfo);
	}
	/**
	 * <b>功能描述：修改密码
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updatePassword(JnzUserInfo jnzUserInfo){
	    return jnzUserInfoDao.updatePassword(jnzUserInfo);
	}
	/**
	 * <b>功能描述：新增用户信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	@Transactional
	public Integer insertJnzUserInfoSelective(JnzUserInfo jnzUserInfo){
	    jnzUserInfoDao.insertJnzUserInfoSelective(jnzUserInfo);
	    JnzUserAsset jnzUserAsset = new JnzUserAsset();
	    jnzUserAsset.setUserId(jnzUserInfo.getId());
	    jnzUserAsset.setTotalAssets(new BigDecimal(0.0));
	    jnzUserAsset.setTotalProfit(new BigDecimal(0.0));
	    jnzUserAsset.setUserPhone(jnzUserInfo.getUserPhone());
		return 	jnzUserAssetDao.insertJnzUserAssetSelective(jnzUserAsset);
	}
	/**
	 * <b>功能描述：新增用户信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserInfo(JnzUserInfo jnzUserInfo){
		return 	jnzUserInfoDao.insertJnzUserInfo(jnzUserInfo);
	}
	 /**
     * 
     * 功能描述: 分页查询用户信息
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzUserInfoListByPage(JnzUserInfo jnzUserInfo,String orderByClause,PageRequest pageRequest,String startDate,String endDate) {
        List<Map<String, Object>> list =  queryJnzUserInfoByList(jnzUserInfo,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize(),startDate,endDate);
        Integer total = queryJnzUserInfoByCount(jnzUserInfo,startDate,endDate);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除用户信息
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzUserInfo(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzUserInfoDao.batchDeleteJnzUserInfo(paraMap);
	    return r1;
	}
	
	
	/**
     * 
     * 功能描述: 根据主键批量冻结/解冻用户信息
     * 
     * @param ids  逗号分隔的ID字符串
     * @return int
	 * @version V1.0.0
	 * @author 王佳田
     */
	public int batchFreezeJnzUserInfo(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzUserInfoDao.batchFreezeJnzUserInfo(paraMap);
	    return r1;
	}
	
	/**
	 * 
	 * 功能描述: 登录
	 * 
	 * @param userName
	 * @param pwd
	 * @return Boolean
	 * @version 1.0.0
	 * @author 王佳田
	 */
	public Map<String,Object> findUserByPwdAndUserName(String userName,String pwd){
	    pwd = EncryptUtil.getMd5(pwd);
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("userName",userName);
        paraMap.put("userPassword",pwd);
	    return jnzUserInfoDao.findUserByPwdAndUserName(paraMap);
	}
	
	
	/**
	 * 
	 * 功能描述: 登录
	 * 
	 * @param userName
	 * @param pwd
	 * @return Boolean
	 * @version 1.0.0
	 * @author 王佳田
	 */
	public JnzUserInfo findUserByUserName(String userName){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("userName",userName);
	    return jnzUserInfoDao.findUserByUserName(paraMap);
	}
	
    public JnzUserInfo findUserByMobile(String mobile) {
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("userPhone",mobile);
        return jnzUserInfoDao.findUserByUserName(paraMap);
    }
}
