package com.ync365.jrpt.business.biz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.JnzUserBankCardDao;
import com.ync365.jrpt.business.dao.JnzUserInfoDao;
import com.ync365.jrpt.business.dao.entity.JnzUserBankCard;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;
import com.ync365.jrpt.util.DateUtil;
import com.ync365.jrpt.util.StringUtil;

/**
 * <b>功能描述：用户银行卡Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzUserBankCardBiz")
public class  JnzUserBankCardBiz {

  private final static Logger logger= Logger.getLogger(JnzUserBankCardBiz.class);
	

	@Autowired
    private JnzUserBankCardDao jnzUserBankCardDao;
	
	@Autowired
	private JnzUserInfoDao jnzUserInfoDao;

		/**
	 * <b>功能描述：查询用户银行卡列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzUserBankCardByList(JnzUserBankCard jnzUserBankCard,String orderByClause,int pageNo,int pageSize,String startDate,String endDate){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzUserBankCard",jnzUserBankCard);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
        if (StringUtil.isEmpty(startDate)) {
        	paraMap.put("startDate",startDate);
		}else {
			paraMap.put("startDate",DateUtil.buildMinOfDate(DateUtil.str2Date(startDate)));
		}
        if (StringUtil.isEmpty(endDate)) {
        	paraMap.put("endDate",endDate);
		}else {
			paraMap.put("endDate",DateUtil.buildMaxOfDate(DateUtil.str2Date(endDate)));
		}
        List<Map<String,Object>> list = jnzUserBankCardDao.queryJnzUserBankCardByList(paraMap);
        // 将用户信息拼接进去
        if(list != null && list.size() >0){
        	for (Map<String, Object> map : list) {
        		Integer userId = MapUtils.getInteger(map, "userId");
        		if(null != userId){
        			Map<String, Object> userMap = 	jnzUserInfoDao.queryJnzUserInfoById(userId);
        			if(null != userMap){
        				map.put("userName", userMap.get("userName"));
        			}
        		}
			}
        }
		return list;
	} 
	/**
	 * <b>功能描述：查询用户银行卡列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzUserBankCardByCount(JnzUserBankCard jnzUserBankCard,String startDate,String endDate){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzUserBankCard",jnzUserBankCard);
        if (StringUtil.isEmpty(startDate)) {
        	paraMap.put("startDate",startDate);
		}else {
			paraMap.put("startDate",DateUtil.buildMinOfDate(DateUtil.str2Date(startDate)));
		}
        if (StringUtil.isEmpty(endDate)) {
        	paraMap.put("endDate",endDate);
		}else {
			paraMap.put("endDate",DateUtil.buildMaxOfDate(DateUtil.str2Date(endDate)));
		}
		return jnzUserBankCardDao.queryJnzUserBankCardByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询用户银行卡信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzUserBankCardById(Integer id){
		return jnzUserBankCardDao.queryJnzUserBankCardById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除用户银行卡
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzUserBankCardById(Integer id){
		return jnzUserBankCardDao.deleteJnzUserBankCardById(id);
	} 
	/**
	 * <b>功能描述：修改用户银行卡
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzUserBankCardBySelective(JnzUserBankCard jnzUserBankCard){
		return jnzUserBankCardDao.updateJnzUserBankCardBySelective(jnzUserBankCard);
	}
	/**
	 * <b>功能描述：新增用户银行卡
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserBankCardSelective(JnzUserBankCard jnzUserBankCard){
		return 	jnzUserBankCardDao.insertJnzUserBankCardSelective(jnzUserBankCard);
	}
	/**
	 * <b>功能描述：新增用户银行卡
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserBankCard(JnzUserBankCard jnzUserBankCard){
		return 	jnzUserBankCardDao.insertJnzUserBankCard(jnzUserBankCard);
	}
	 /**
     * 
     * 功能描述: 分页查询用户银行卡
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzUserBankCardListByPage(JnzUserBankCard jnzUserBankCard,String orderByClause,PageRequest pageRequest,String startDate,String endDate) {
        List<Map<String, Object>> list =  queryJnzUserBankCardByList(jnzUserBankCard,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize(),startDate,endDate);
        Integer total = queryJnzUserBankCardByCount(jnzUserBankCard,startDate,endDate);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除用户银行卡
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzUserBankCard(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzUserBankCardDao.batchDeleteJnzUserBankCard(paraMap);
	    return r1;
	}
}
