package com.ync365.jrpt.business.biz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.JnzUserAssetDao;
import com.ync365.jrpt.business.dao.JnzUserInfoDao;
import com.ync365.jrpt.business.dao.entity.JnzUserAsset;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

/**
 * <b>功能描述：用户资产Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzUserAssetBiz")
public class  JnzUserAssetBiz {

  private final static Logger logger= Logger.getLogger(JnzUserAssetBiz.class);
	

	@Autowired
    private JnzUserAssetDao jnzUserAssetDao;
	
	@Autowired
	private JnzUserInfoDao jnzUserInfoDao;

		/**
	 * <b>功能描述：查询用户资产列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzUserAssetByList(JnzUserAsset jnzUserAsset,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzUserAsset",jnzUserAsset);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
        return jnzUserAssetDao.queryJnzUserAssetByList(paraMap);
	} 
	
	public List<Map<String,Object>> queryJnzUserAsset(JnzUserAsset jnzUserAsset,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzUserAsset",jnzUserAsset);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
        List<Map<String,Object>> list = jnzUserAssetDao.queryJnzUserAsset(paraMap);
        // 将用户信息拼接进去
        if(list != null && list.size() >0){
        	for (Map<String, Object> map : list) {
        		Integer userId = MapUtils.getInteger(map, "userId");
        		if(null != userId){
        			Map<String, Object> userMap = 	jnzUserInfoDao.queryJnzUserInfoById(userId);
        			if(null != userMap){
        				map.put("userName", userMap.get("userName"));
        			}
        		}
			}
        }
		return list;
	} 
	
	/**
	 * <b>功能描述：查询用户资产列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzUserAssetByCount(JnzUserAsset jnzUserAsset){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzUserAsset",jnzUserAsset);
		return jnzUserAssetDao.queryJnzUserAssetByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询用户资产信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzUserAssetById(Integer id){
		return jnzUserAssetDao.queryJnzUserAssetById(id);
	} 
	/**
	 * <b>功能描述：根据ID查询用户资产明细信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzUserAssetByUserId(Integer userId){
		return jnzUserAssetDao.queryJnzUserAssetByUserId(userId);
	} 
	/**
	 * <b>功能描述：根据ID删除用户资产
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzUserAssetById(Integer id){
		return jnzUserAssetDao.deleteJnzUserAssetById(id);
	} 
	/**
	 * <b>功能描述：修改用户资产
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzUserAssetBySelective(JnzUserAsset jnzUserAsset){
		return jnzUserAssetDao.updateJnzUserAssetBySelective(jnzUserAsset);
	}
	/**
	 * <b>功能描述：新增用户资产
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserAssetSelective(JnzUserAsset jnzUserAsset){
		return 	jnzUserAssetDao.insertJnzUserAssetSelective(jnzUserAsset);
	}
	/**
	 * <b>功能描述：新增用户资产
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserAsset(JnzUserAsset jnzUserAsset){
		return 	jnzUserAssetDao.insertJnzUserAsset(jnzUserAsset);
	}
	 /**
     * 
     * 功能描述: 分页查询用户资产
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzUserAssetListByPage(JnzUserAsset jnzUserAsset,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzUserAssetByList(jnzUserAsset,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzUserAssetByCount(jnzUserAsset);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
    
    public Page<Map<String, Object>> querysJnzUserAssetListByPage(JnzUserAsset jnzUserAsset,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzUserAsset(jnzUserAsset,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzUserAssetByCount(jnzUserAsset);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
    
	 /**
	  * 
	  * 功能描述: 批量删除用户资产
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzUserAsset(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzUserAssetDao.batchDeleteJnzUserAsset(paraMap);
	    return r1;
	}
	
	public Map<String, Object> queryUserProfitStatics(){
		return jnzUserAssetDao.queryUserProfitStatics();
	}
}
