package com.ync365.jrpt.business.biz;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.apache.ibatis.annotations.Param;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;
import com.ync365.jrpt.business.dao.JnzSysVersionDetailDao;
import com.ync365.jrpt.business.dao.entity.JnzSysVersionDetail;

/**
 * <b>功能描述：系统版本详细说明Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzSysVersionDetailBiz")
public class  JnzSysVersionDetailBiz {

  private final static Logger logger= Logger.getLogger(JnzSysVersionDetailBiz.class);
	

	@Autowired
    private JnzSysVersionDetailDao jnzSysVersionDetailDao;

		/**
	 * <b>功能描述：查询系统版本详细说明列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzSysVersionDetailByList(JnzSysVersionDetail jnzSysVersionDetail,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzSysVersionDetail",jnzSysVersionDetail);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzSysVersionDetailDao.queryJnzSysVersionDetailByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询系统版本详细说明列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzSysVersionDetailByCount(JnzSysVersionDetail jnzSysVersionDetail){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzSysVersionDetail",jnzSysVersionDetail);
		return jnzSysVersionDetailDao.queryJnzSysVersionDetailByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询系统版本详细说明信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzSysVersionDetailById(Integer id){
		return jnzSysVersionDetailDao.queryJnzSysVersionDetailById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除系统版本详细说明
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzSysVersionDetailById(Integer id){
		return jnzSysVersionDetailDao.deleteJnzSysVersionDetailById(id);
	} 
	/**
	 * <b>功能描述：修改系统版本详细说明
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzSysVersionDetailBySelective(JnzSysVersionDetail jnzSysVersionDetail){
		return jnzSysVersionDetailDao.updateJnzSysVersionDetailBySelective(jnzSysVersionDetail);
	}
	/**
	 * <b>功能描述：新增系统版本详细说明
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzSysVersionDetailSelective(JnzSysVersionDetail jnzSysVersionDetail){
		return 	jnzSysVersionDetailDao.insertJnzSysVersionDetailSelective(jnzSysVersionDetail);
	}
	/**
	 * <b>功能描述：新增系统版本详细说明
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzSysVersionDetail(JnzSysVersionDetail jnzSysVersionDetail){
		return 	jnzSysVersionDetailDao.insertJnzSysVersionDetail(jnzSysVersionDetail);
	}
	 /**
     * 
     * 功能描述: 分页查询系统版本详细说明
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzSysVersionDetailListByPage(JnzSysVersionDetail jnzSysVersionDetail,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzSysVersionDetailByList(jnzSysVersionDetail,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzSysVersionDetailByCount(jnzSysVersionDetail);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除系统版本详细说明
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzSysVersionDetail(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzSysVersionDetailDao.batchDeleteJnzSysVersionDetail(paraMap);
	    return r1;
	}
}
