package com.ync365.jrpt.business.biz;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.apache.ibatis.annotations.Param;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;
import com.ync365.jrpt.business.dao.JnzSysVersionDao;
import com.ync365.jrpt.business.dao.entity.JnzSysVersion;

/**
 * <b>功能描述：系统版本信息Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzSysVersionBiz")
public class  JnzSysVersionBiz {

  private final static Logger logger= Logger.getLogger(JnzSysVersionBiz.class);
	

	@Autowired
    private JnzSysVersionDao jnzSysVersionDao;

		/**
	 * <b>功能描述：查询系统版本信息列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzSysVersionByList(JnzSysVersion jnzSysVersion,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzSysVersion",jnzSysVersion);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzSysVersionDao.queryJnzSysVersionByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询系统版本信息列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzSysVersionByCount(JnzSysVersion jnzSysVersion){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzSysVersion",jnzSysVersion);
		return jnzSysVersionDao.queryJnzSysVersionByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询系统版本信息信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzSysVersionById(Integer id){
		return jnzSysVersionDao.queryJnzSysVersionById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除系统版本信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzSysVersionById(Integer id){
		return jnzSysVersionDao.deleteJnzSysVersionById(id);
	} 
	/**
	 * <b>功能描述：修改系统版本信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzSysVersionBySelective(JnzSysVersion jnzSysVersion){
		return jnzSysVersionDao.updateJnzSysVersionBySelective(jnzSysVersion);
	}
	/**
	 * <b>功能描述：新增系统版本信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzSysVersionSelective(JnzSysVersion jnzSysVersion){
		return 	jnzSysVersionDao.insertJnzSysVersionSelective(jnzSysVersion);
	}
	/**
	 * <b>功能描述：新增系统版本信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzSysVersion(JnzSysVersion jnzSysVersion){
		return 	jnzSysVersionDao.insertJnzSysVersion(jnzSysVersion);
	}
	 /**
     * 
     * 功能描述: 分页查询系统版本信息
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzSysVersionListByPage(JnzSysVersion jnzSysVersion,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzSysVersionByList(jnzSysVersion,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzSysVersionByCount(jnzSysVersion);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除系统版本信息
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzSysVersion(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzSysVersionDao.batchDeleteJnzSysVersion(paraMap);
	    return r1;
	}
}
