package com.ync365.jrpt.business.biz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.JnzShufflingFigureDao;
import com.ync365.jrpt.business.dao.entity.JnzShufflingFigure;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

/**
 * <b>功能描述：广告轮播图Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzShufflingFigureBiz")
public class  JnzShufflingFigureBiz {

  private final static Logger logger= Logger.getLogger(JnzShufflingFigureBiz.class);
	

	@Autowired
    private JnzShufflingFigureDao jnzShufflingFigureDao;

		/**
	 * <b>功能描述：查询广告轮播图列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzShufflingFigureByList(JnzShufflingFigure jnzShufflingFigure,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzShufflingFigure",jnzShufflingFigure);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzShufflingFigureDao.queryJnzShufflingFigureByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询广告轮播图列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzShufflingFigureByCount(JnzShufflingFigure jnzShufflingFigure){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzShufflingFigure",jnzShufflingFigure);
		return jnzShufflingFigureDao.queryJnzShufflingFigureByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询广告轮播图信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzShufflingFigureById(Integer id){
		return jnzShufflingFigureDao.queryJnzShufflingFigureById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除广告轮播图
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzShufflingFigureById(Integer id){
		return jnzShufflingFigureDao.deleteJnzShufflingFigureById(id);
	} 
	/**
	 * <b>功能描述：修改广告轮播图
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzShufflingFigureBySelective(JnzShufflingFigure jnzShufflingFigure){
		return jnzShufflingFigureDao.updateJnzShufflingFigureBySelective(jnzShufflingFigure);
	}
	/**
	 * <b>功能描述：新增广告轮播图
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzShufflingFigureSelective(JnzShufflingFigure jnzShufflingFigure){
		return 	jnzShufflingFigureDao.insertJnzShufflingFigureSelective(jnzShufflingFigure);
	}
	/**
	 * <b>功能描述：新增广告轮播图
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzShufflingFigure(JnzShufflingFigure jnzShufflingFigure){
		return 	jnzShufflingFigureDao.insertJnzShufflingFigure(jnzShufflingFigure);
	}
	 /**
     * 
     * 功能描述: 分页查询广告轮播图
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzShufflingFigureListByPage(JnzShufflingFigure jnzShufflingFigure,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzShufflingFigureByList(jnzShufflingFigure,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzShufflingFigureByCount(jnzShufflingFigure);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除广告轮播图
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzShufflingFigure(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzShufflingFigureDao.batchDeleteJnzShufflingFigure(paraMap);
	    return r1;
	}
	
	
	/**
	 * 
	 * 功能描述:通用获取广告或轮播图 
	 * 
	 * @param jnzShufflingFigure 广告参数
	 * @param pageNo 页数
	 * @param pageSize 页面大小
	 * @return List<JnzShufflingFigure>
	 * @date 2016-11-9
	 * @since 1.0.0
	 * @version 1.0.0
	 * @author 徐大伟
	 */
    public List<JnzShufflingFigure> getJnzShufflingFigureList(JnzShufflingFigure jnzShufflingFigure,Integer pageNo,Integer pageSize) {
        String limitClause ="";
        if(pageNo !=0 && pageSize != 0){
            limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
        }
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzShufflingFigure",jnzShufflingFigure);
        paraMap.put("limitClause",limitClause);
        return jnzShufflingFigureDao.getJnzShufflingFigureList(paraMap);
    }
}
