package com.ync365.jrpt.business.biz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.JnzSearchWordDao;
import com.ync365.jrpt.business.dao.entity.JnzSearchWord;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

/**
 * <b>功能描述：搜索词Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzSearchWordBiz")
public class  JnzSearchWordBiz {

  private final static Logger logger= Logger.getLogger(JnzSearchWordBiz.class);
	

	@Autowired
    private JnzSearchWordDao jnzSearchWordDao;

		/**
	 * <b>功能描述：查询搜索词列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzSearchWordByList(JnzSearchWord jnzSearchWord,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzSearchWord",jnzSearchWord);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzSearchWordDao.queryJnzSearchWordByList(paraMap);
	} 
	/**
	 * 
	 * 功能描述:获取搜索历史 
	 * 
	 * @return List<String>
	 * @version 1.0.0
	 * @author 徐大伟
	 */
	public List<String> getSearchHistory(){
	    return jnzSearchWordDao.getSearchHistory();
	}
	/**
	 * <b>功能描述：查询搜索词列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzSearchWordByCount(JnzSearchWord jnzSearchWord){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzSearchWord",jnzSearchWord);
		return jnzSearchWordDao.queryJnzSearchWordByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询搜索词信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzSearchWordById(Integer id){
		return jnzSearchWordDao.queryJnzSearchWordById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除搜索词
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzSearchWordById(Integer id){
		return jnzSearchWordDao.deleteJnzSearchWordById(id);
	} 
	/**
	 * <b>功能描述：修改搜索词
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzSearchWordBySelective(JnzSearchWord jnzSearchWord){
		return jnzSearchWordDao.updateJnzSearchWordBySelective(jnzSearchWord);
	}
	/**
	 * <b>功能描述：新增搜索词
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzSearchWordSelective(JnzSearchWord jnzSearchWord){
		return 	jnzSearchWordDao.insertJnzSearchWordSelective(jnzSearchWord);
	}
	/**
	 * <b>功能描述：新增搜索词
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzSearchWord(JnzSearchWord jnzSearchWord){
		return 	jnzSearchWordDao.insertJnzSearchWord(jnzSearchWord);
	}
	 /**
     * 
     * 功能描述: 分页查询搜索词
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzSearchWordListByPage(JnzSearchWord jnzSearchWord,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzSearchWordByList(jnzSearchWord,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzSearchWordByCount(jnzSearchWord);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除搜索词
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzSearchWord(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzSearchWordDao.batchDeleteJnzSearchWord(paraMap);
	    return r1;
	}
}
