package com.ync365.jrpt.business.biz;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.apache.ibatis.annotations.Param;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;
import com.ync365.jrpt.business.dao.JnzScreenValueDao;
import com.ync365.jrpt.business.dao.entity.JnzScreenValue;

/**
 * <b>功能描述：筛选条件值Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzScreenValueBiz")
public class  JnzScreenValueBiz {

  private final static Logger logger= Logger.getLogger(JnzScreenValueBiz.class);
	

	@Autowired
    private JnzScreenValueDao jnzScreenValueDao;

		/**
	 * <b>功能描述：查询筛选条件值列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<JnzScreenValue> queryJnzScreenValueByList(JnzScreenValue jnzScreenValue,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzScreenValue",jnzScreenValue);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzScreenValueDao.queryJnzScreenValueByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询筛选条件值列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzScreenValueByCount(JnzScreenValue jnzScreenValue){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzScreenValue",jnzScreenValue);
		return jnzScreenValueDao.queryJnzScreenValueByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询筛选条件值信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public JnzScreenValue  queryJnzScreenValueById(Integer id){
		return jnzScreenValueDao.queryJnzScreenValueById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除筛选条件值
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzScreenValueById(Integer id){
		return jnzScreenValueDao.deleteJnzScreenValueById(id);
	} 
	/**
	 * <b>功能描述：修改筛选条件值
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzScreenValueBySelective(JnzScreenValue jnzScreenValue){
		return jnzScreenValueDao.updateJnzScreenValueBySelective(jnzScreenValue);
	}
	/**
	 * <b>功能描述：新增筛选条件值
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzScreenValueSelective(JnzScreenValue jnzScreenValue){
		return 	jnzScreenValueDao.insertJnzScreenValueSelective(jnzScreenValue);
	}
	/**
	 * <b>功能描述：新增筛选条件值
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzScreenValue(JnzScreenValue jnzScreenValue){
		return 	jnzScreenValueDao.insertJnzScreenValue(jnzScreenValue);
	}
	 /**
     * 
     * 功能描述: 分页查询筛选条件值
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<JnzScreenValue> findJnzScreenValueListByPage(JnzScreenValue jnzScreenValue,String orderByClause,PageRequest pageRequest) {
        List<JnzScreenValue> list =  queryJnzScreenValueByList(jnzScreenValue,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzScreenValueByCount(jnzScreenValue);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除筛选条件值
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzScreenValue(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzScreenValueDao.batchDeleteJnzScreenValue(paraMap);
	    return r1;
	}
}
