package com.ync365.jrpt.business.biz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.JnzScreenCateDao;
import com.ync365.jrpt.business.dao.entity.JnzScreenCate;
import com.ync365.jrpt.business.dao.entity.TableInfo;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

/**
 * <b>功能描述：筛选条件分类Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzScreenCateBiz")
public class  JnzScreenCateBiz {

  private final static Logger logger= LoggerFactory.getLogger(JnzScreenCateBiz.class);

	@Autowired
    private JnzScreenCateDao jnzScreenCateDao;
	
	@Autowired
    private TableInfoBiz tableInfoBiz;
    
	/**
	 * <b>功能描述：查询筛选条件分类列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<JnzScreenCate> queryJnzScreenCateByList(JnzScreenCate jnzScreenCate,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzScreenCate",jnzScreenCate);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzScreenCateDao.queryJnzScreenCateByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询筛选条件分类列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzScreenCateByCount(JnzScreenCate jnzScreenCate){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzScreenCate",jnzScreenCate);
		return jnzScreenCateDao.queryJnzScreenCateByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询筛选条件分类信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public JnzScreenCate  queryJnzScreenCateById(Integer id){
		return jnzScreenCateDao.queryJnzScreenCateById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除筛选条件分类
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzScreenCateById(Integer id){
		return jnzScreenCateDao.deleteJnzScreenCateById(id);
	} 
	/**
	 * <b>功能描述：修改筛选条件分类
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzScreenCateBySelective(JnzScreenCate jnzScreenCate){
		return jnzScreenCateDao.updateJnzScreenCateBySelective(jnzScreenCate);
	}
	/**
	 * <b>功能描述：新增筛选条件分类
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzScreenCateSelective(JnzScreenCate jnzScreenCate){
		TableInfo tableInfo = tableInfoBiz.getProductInfoByField(jnzScreenCate.getProductColumn());
		jnzScreenCate.setProductColumnType(tableInfo.getType());
		jnzScreenCate.setProductColumnName(tableInfo.getComment());
		jnzScreenCate.setProductColumnCommont(tableInfo.getComment());
		return 	jnzScreenCateDao.insertJnzScreenCateSelective(jnzScreenCate);
	}
	/**
	 * <b>功能描述：新增筛选条件分类
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzScreenCate(JnzScreenCate jnzScreenCate){
		return 	jnzScreenCateDao.insertJnzScreenCate(jnzScreenCate);
	}
	 /**
     * 
     * 功能描述: 分页查询筛选条件分类
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<JnzScreenCate> findJnzScreenCateListByPage(JnzScreenCate jnzScreenCate,String orderByClause,PageRequest pageRequest) {
        List<JnzScreenCate> list =  queryJnzScreenCateByList(jnzScreenCate,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzScreenCateByCount(jnzScreenCate);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除筛选条件分类
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzScreenCate(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzScreenCateDao.batchDeleteJnzScreenCate(paraMap);
	    return r1;
	}
}
