package com.ync365.jrpt.business.biz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.JnzProductInfoDao;
import com.ync365.jrpt.business.dao.entity.JnzProductInfo;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

/**
 * <b>功能描述：理财产品Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzProductInfoBiz")
public class  JnzProductInfoBiz {

  private final static Logger logger= Logger.getLogger(JnzProductInfoBiz.class);
	

	@Autowired
    private JnzProductInfoDao jnzProductInfoDao;

		/**
	 * <b>功能描述：查询理财产品列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzProductInfoByList(JnzProductInfo jnzProductInfo,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzProductInfo",jnzProductInfo);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzProductInfoDao.queryJnzProductInfoByList(paraMap);
	} 
	public List<JnzProductInfo> getProductInfoByList(JnzProductInfo jnzProductInfo,String orderByClause,int pageNo,int pageSize,String param){
	    String limitClause ="";
	    if(pageNo !=0 && pageSize != 0){
	        limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
	    }
	    try {
	    	Map<String,Object> paraMap = new HashMap<String,Object>();
			paraMap.put("jnzProductInfo",jnzProductInfo);
		    paraMap.put("orderByClause",orderByClause);
		    paraMap.put("paramStr",param);
		    paraMap.put("limitClause",limitClause);
		    return jnzProductInfoDao.getProductInfoByList(paraMap);
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
			Map<String,Object> paraMap = new HashMap<String,Object>();
			paraMap.put("jnzProductInfo",jnzProductInfo);
		    paraMap.put("orderByClause",orderByClause);
		    paraMap.put("limitClause",limitClause);
		    return jnzProductInfoDao.getProductInfoByList(paraMap);
		}
	   
	} 
	/**
	 * <b>功能描述：查询理财产品列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzProductInfoByCount(JnzProductInfo jnzProductInfo){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzProductInfo",jnzProductInfo);
		return jnzProductInfoDao.queryJnzProductInfoByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询理财产品信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzProductInfoById(Integer id){
		return jnzProductInfoDao.queryJnzProductInfoById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除理财产品
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzProductInfoById(Integer id){
		return jnzProductInfoDao.deleteJnzProductInfoById(id);
	} 
	/**
	 * <b>功能描述：修改理财产品
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzProductInfoBySelective(JnzProductInfo jnzProductInfo){
		return jnzProductInfoDao.updateJnzProductInfoBySelective(jnzProductInfo);
	}
	/**
	 * <b>功能描述：新增理财产品
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzProductInfoSelective(JnzProductInfo jnzProductInfo){
		return 	jnzProductInfoDao.insertJnzProductInfoSelective(jnzProductInfo);
	}
	/**
	 * <b>功能描述：新增理财产品
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzProductInfo(JnzProductInfo jnzProductInfo){
		return 	jnzProductInfoDao.insertJnzProductInfo(jnzProductInfo);
	}
	 /**
     * 
     * 功能描述: 分页查询理财产品
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzProductInfoListByPage(JnzProductInfo jnzProductInfo,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzProductInfoByList(jnzProductInfo,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzProductInfoByCount(jnzProductInfo);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
    /**
     * 
     * 功能描述: 分页查询理财产品
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<JnzProductInfo> getJnzProductInfoListByPage(JnzProductInfo jnzProductInfo,String orderByClause,PageRequest pageRequest,String param) {
        List<JnzProductInfo> list =  getProductInfoByList(jnzProductInfo,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize(),param);
        Integer total = queryJnzProductInfoByCount(jnzProductInfo);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除理财产品
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzProductInfo(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzProductInfoDao.batchDeleteJnzProductInfo(paraMap);
	    return r1;
	}
	/**
	 * 
	 * 功能描述: 搜索
	 * 
	 * @param keyword
	 * @param pageRequest
	 * @return Page<JnzProductInfo>
	 * @version 1.0.0
	 * @author 徐大伟
	 */
    public Page<JnzProductInfo> search(String keyword,Integer pageNo,Integer pageSize) {
        String limitClause ="";
        if(pageNo !=0 && pageSize != 0){
            limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
        }
        PageRequest pageRequest = new PageRequest(pageNo, pageSize);
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("keyword",keyword);
        paraMap.put("limitClause",limitClause);
        List<JnzProductInfo> list = jnzProductInfoDao.search(paraMap);
        int total = jnzProductInfoDao.searchCount(paraMap);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
    /**
     * 
     * 功能描述: 查询产品详情
     * 
     * @param productId
     * @return JnzProductInfo
     * @date 2016-11-10
     * @since 1.0.0
     * @version 1.0.0
     * @author 徐大伟
     */
    public JnzProductInfo getProductInfoById(Integer productId) {
        return jnzProductInfoDao.getJnzProductInfoById(productId);
    }
}
