package com.ync365.jrpt.business.biz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.JnzProductAgreementDao;
import com.ync365.jrpt.business.dao.entity.JnzProductAgreement;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

/**
 * <b>功能描述：产品合同Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzProductAgreementBiz")
public class  JnzProductAgreementBiz {

  private final static Logger logger= Logger.getLogger(JnzProductAgreementBiz.class);
	

	@Autowired
    private JnzProductAgreementDao jnzProductAgreementDao;

		/**
	 * <b>功能描述：查询产品合同列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzProductAgreementByList(JnzProductAgreement jnzProductAgreement,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzProductAgreement",jnzProductAgreement);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzProductAgreementDao.queryJnzProductAgreementByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询产品合同列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzProductAgreementByCount(JnzProductAgreement jnzProductAgreement){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzProductAgreement",jnzProductAgreement);
		return jnzProductAgreementDao.queryJnzProductAgreementByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询产品合同信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzProductAgreementById(Integer id){
		return jnzProductAgreementDao.queryJnzProductAgreementById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除产品合同
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzProductAgreementById(Integer id){
		return jnzProductAgreementDao.deleteJnzProductAgreementById(id);
	} 
	/**
	 * <b>功能描述：修改产品合同
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzProductAgreementBySelective(JnzProductAgreement jnzProductAgreement){
		return jnzProductAgreementDao.updateJnzProductAgreementBySelective(jnzProductAgreement);
	}
	/**
	 * <b>功能描述：新增产品合同
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzProductAgreementSelective(JnzProductAgreement jnzProductAgreement){
		return 	jnzProductAgreementDao.insertJnzProductAgreementSelective(jnzProductAgreement);
	}
	/**
	 * <b>功能描述：新增产品合同
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzProductAgreement(JnzProductAgreement jnzProductAgreement){
		return 	jnzProductAgreementDao.insertJnzProductAgreement(jnzProductAgreement);
	}
	 /**
     * 
     * 功能描述: 分页查询产品合同
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzProductAgreementListByPage(JnzProductAgreement jnzProductAgreement,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzProductAgreementByList(jnzProductAgreement,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzProductAgreementByCount(jnzProductAgreement);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除产品合同
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzProductAgreement(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzProductAgreementDao.batchDeleteJnzProductAgreement(paraMap);
	    return r1;
	}
}
