package com.ync365.jrpt.business.biz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.JnzPartnerDao;
import com.ync365.jrpt.business.dao.entity.JnzPartner;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

/**
 * <b>功能描述：合作伙伴Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzPartnerBiz")
public class  JnzPartnerBiz {

  private final static Logger logger= Logger.getLogger(JnzPartnerBiz.class);
	

	@Autowired
    private JnzPartnerDao jnzPartnerDao;

		/**
	 * <b>功能描述：查询合作伙伴列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzPartnerByList(JnzPartner jnzPartner,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzPartner",jnzPartner);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzPartnerDao.queryJnzPartnerByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询合作伙伴列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzPartnerByCount(JnzPartner jnzPartner){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzPartner",jnzPartner);
		return jnzPartnerDao.queryJnzPartnerByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询合作伙伴信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzPartnerById(Integer id){
		return jnzPartnerDao.queryJnzPartnerById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除合作伙伴
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzPartnerById(Integer id){
		return jnzPartnerDao.deleteJnzPartnerById(id);
	} 
	/**
	 * <b>功能描述：修改合作伙伴
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzPartnerBySelective(JnzPartner jnzPartner){
		return jnzPartnerDao.updateJnzPartnerBySelective(jnzPartner);
	}
	/**
	 * <b>功能描述：新增合作伙伴
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzPartnerSelective(JnzPartner jnzPartner){
		return 	jnzPartnerDao.insertJnzPartnerSelective(jnzPartner);
	}
	/**
	 * <b>功能描述：新增合作伙伴
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzPartner(JnzPartner jnzPartner){
		return 	jnzPartnerDao.insertJnzPartner(jnzPartner);
	}
	 /**
     * 
     * 功能描述: 分页查询合作伙伴
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzPartnerListByPage(JnzPartner jnzPartner,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzPartnerByList(jnzPartner,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzPartnerByCount(jnzPartner);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除合作伙伴
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzPartner(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzPartnerDao.batchDeleteJnzPartner(paraMap);
	    return r1;
	}
}
