package com.ync365.jrpt.business.biz;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ync365.jrpt.business.dao.JnzNewsDao;
import com.ync365.jrpt.business.dao.entity.JnzNews;
import com.ync365.jrpt.business.enums.NewsPubEnum;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

/**
 * <b>功能描述：咨询Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzNewsBiz")
public class  JnzNewsBiz {

  private final static Logger logger= Logger.getLogger(JnzNewsBiz.class);
	

	@Autowired
    private JnzNewsDao jnzNewsDao;

		/**
	 * <b>功能描述：查询咨询列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzNewsByList(JnzNews jnzNews,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzNews",jnzNews);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzNewsDao.queryJnzNewsByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询咨询列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzNewsByCount(JnzNews jnzNews){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzNews",jnzNews);
		return jnzNewsDao.queryJnzNewsByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询咨询信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzNewsById(Integer id){
		return jnzNewsDao.queryJnzNewsById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除咨询
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzNewsById(Integer id){
		return jnzNewsDao.deleteJnzNewsById(id);
	} 
	/**
	 * <b>功能描述：修改咨询
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzNewsBySelective(JnzNews jnzNews){
		return jnzNewsDao.updateJnzNewsBySelective(jnzNews);
	}
	/**
	 * <b>功能描述：新增咨询
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzNewsSelective(JnzNews jnzNews){
		return 	jnzNewsDao.insertJnzNewsSelective(jnzNews);
	}
	/**
	 * <b>功能描述：新增咨询
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzNews(JnzNews jnzNews){
		return 	jnzNewsDao.insertJnzNews(jnzNews);
	}
	 /**
     * 
     * 功能描述: 分页查询咨询
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzNewsListByPage(JnzNews jnzNews,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzNewsByList(jnzNews,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzNewsByCount(jnzNews);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除咨询
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzNews(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzNewsDao.batchDeleteJnzNews(paraMap);
	    return r1;
	}
	/**
	 * 
	 * 功能描述: 批量发布批量取消
	 * 
	 * @param ids
	 * @return int
	 * @version 1.0.0
	 * @author 王佳田
	 */
	@Transactional
    public int batchPubNews(String ids) {
        int i = 0;
        String[] idArray= ids.split(",");
        for(String item : idArray){
            Map<String,Object> map = jnzNewsDao.queryJnzNewsById(Integer.parseInt(item));
            if(null != map){
                JnzNews jnzNews = new JnzNews();
                jnzNews.setId(MapUtils.getInteger(map, "id"));
                Integer pub = MapUtils.getInteger(map, "isPub");
                if(pub.equals(NewsPubEnum.PUB.getValue())){
                    jnzNews.setIsPub(NewsPubEnum.CANCEL_PUB.getValue());
                }else{
                    jnzNews.setIsPub(NewsPubEnum.PUB.getValue());
                    
                    SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-DD HH:MM:SS");
                    jnzNews.setPubTime(sdf.format(new Date()));
                }
                jnzNewsDao.updateJnzNewsBySelective(jnzNews);
            }
            i++;
        }
        
        return i;
    }
}
