package com.ync365.jrpt.business.biz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.JnzMsgDao;
import com.ync365.jrpt.business.dao.entity.JnzMsg;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;

/**
 * <b>功能描述：消息Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzMsgBiz")
public class  JnzMsgBiz {

  private final static Logger logger= Logger.getLogger(JnzMsgBiz.class);
	

	@Autowired
    private JnzMsgDao jnzMsgDao;

		/**
	 * <b>功能描述：查询消息列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzMsgByList(JnzMsg jnzMsg,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzMsg",jnzMsg);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzMsgDao.queryJnzMsgByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询消息列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzMsgByCount(JnzMsg jnzMsg){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzMsg",jnzMsg);
		return jnzMsgDao.queryJnzMsgByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询消息信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzMsgById(Integer id){
		return jnzMsgDao.queryJnzMsgById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除消息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzMsgById(Integer id){
		return jnzMsgDao.deleteJnzMsgById(id);
	} 
	/**
	 * <b>功能描述：修改消息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzMsgBySelective(JnzMsg jnzMsg){
		return jnzMsgDao.updateJnzMsgBySelective(jnzMsg);
	}
	/**
	 * <b>功能描述：新增消息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzMsgSelective(JnzMsg jnzMsg){
		return 	jnzMsgDao.insertJnzMsgSelective(jnzMsg);
	}
	/**
	 * <b>功能描述：新增消息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzMsg(JnzMsg jnzMsg){
		return 	jnzMsgDao.insertJnzMsg(jnzMsg);
	}
	 /**
     * 
     * 功能描述: 分页查询消息
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzMsgListByPage(JnzMsg jnzMsg,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzMsgByList(jnzMsg,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzMsgByCount(jnzMsg);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除消息
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzMsg(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzMsgDao.batchDeleteJnzMsg(paraMap);
	    return r1;
	}
}
