package com.ync365.jrpt.business.biz;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.apache.ibatis.annotations.Param;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;
import com.ync365.jrpt.business.dao.JnzBanksDao;
import com.ync365.jrpt.business.dao.entity.JnzBanks;

/**
 * <b>功能描述：银行列表Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("jnzBanksBiz")
public class  JnzBanksBiz {

  private final static Logger logger= Logger.getLogger(JnzBanksBiz.class);
	

	@Autowired
    private JnzBanksDao jnzBanksDao;

		/**
	 * <b>功能描述：查询银行列表列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzBanksByList(JnzBanks jnzBanks,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzBanks",jnzBanks);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return jnzBanksDao.queryJnzBanksByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询银行列表列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzBanksByCount(JnzBanks jnzBanks){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("jnzBanks",jnzBanks);
		return jnzBanksDao.queryJnzBanksByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询银行列表信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzBanksById(Integer id){
		return jnzBanksDao.queryJnzBanksById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除银行列表
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzBanksById(Integer id){
		return jnzBanksDao.deleteJnzBanksById(id);
	} 
	/**
	 * <b>功能描述：修改银行列表
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzBanksBySelective(JnzBanks jnzBanks){
		return jnzBanksDao.updateJnzBanksBySelective(jnzBanks);
	}
	/**
	 * <b>功能描述：新增银行列表
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzBanksSelective(JnzBanks jnzBanks){
		return 	jnzBanksDao.insertJnzBanksSelective(jnzBanks);
	}
	/**
	 * <b>功能描述：新增银行列表
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzBanks(JnzBanks jnzBanks){
		return 	jnzBanksDao.insertJnzBanks(jnzBanks);
	}
	 /**
     * 
     * 功能描述: 分页查询银行列表
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findJnzBanksListByPage(JnzBanks jnzBanks,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryJnzBanksByList(jnzBanks,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryJnzBanksByCount(jnzBanks);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除银行列表
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteJnzBanks(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=jnzBanksDao.batchDeleteJnzBanks(paraMap);
	    return r1;
	}
}
