package com.ync365.jrpt.business.biz;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import org.apache.ibatis.annotations.Param;

import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;
import com.ync365.jrpt.business.dao.BasicBankInfoDao;
import com.ync365.jrpt.business.dao.entity.BasicBankInfo;

/**
 * <b>功能描述：银行基础信息Biz
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
@Service("basicBankInfoBiz")
public class  BasicBankInfoBiz {

  private final static Logger logger= Logger.getLogger(BasicBankInfoBiz.class);
	

	@Autowired
    private BasicBankInfoDao basicBankInfoDao;

		/**
	 * <b>功能描述：查询银行基础信息列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryBasicBankInfoByList(BasicBankInfo basicBankInfo,String orderByClause,int pageNo,int pageSize){
		String limitClause ="";
		if(pageNo !=0 && pageSize != 0){
			limitClause = "limit " + ((pageNo-1)*pageSize) + "," + pageSize;
		}
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("basicBankInfo",basicBankInfo);
        paraMap.put("orderByClause",orderByClause);
        paraMap.put("limitClause",limitClause);
		return basicBankInfoDao.queryBasicBankInfoByList(paraMap);
	} 
	/**
	 * <b>功能描述：查询银行基础信息列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryBasicBankInfoByCount(BasicBankInfo basicBankInfo){
	    Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("basicBankInfo",basicBankInfo);
		return basicBankInfoDao.queryBasicBankInfoByCount(paraMap);
	} 
	/**
	 * <b>功能描述：根据ID查询银行基础信息信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryBasicBankInfoById(Integer id){
		return basicBankInfoDao.queryBasicBankInfoById(id);
	} 
	/**
	 * <b>功能描述：根据ID删除银行基础信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteBasicBankInfoById(Integer id){
		return basicBankInfoDao.deleteBasicBankInfoById(id);
	} 
	/**
	 * <b>功能描述：修改银行基础信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateBasicBankInfoBySelective(BasicBankInfo basicBankInfo){
		return basicBankInfoDao.updateBasicBankInfoBySelective(basicBankInfo);
	}
	/**
	 * <b>功能描述：新增银行基础信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertBasicBankInfoSelective(BasicBankInfo basicBankInfo){
		return 	basicBankInfoDao.insertBasicBankInfoSelective(basicBankInfo);
	}
	/**
	 * <b>功能描述：新增银行基础信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertBasicBankInfo(BasicBankInfo basicBankInfo){
		return 	basicBankInfoDao.insertBasicBankInfo(basicBankInfo);
	}
	 /**
     * 
     * 功能描述: 分页查询银行基础信息
     * @param pageRequest
     * @return Page<Map<String,Object>>
     * @version V1.0.0
     * @author 徐大伟
     */
    public Page<Map<String, Object>> findBasicBankInfoListByPage(BasicBankInfo basicBankInfo,String orderByClause,PageRequest pageRequest) {
        List<Map<String, Object>> list =  queryBasicBankInfoByList(basicBankInfo,orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = queryBasicBankInfoByCount(basicBankInfo);
        return PageBuilder.buildPage(pageRequest, list, total);
    }
	 /**
	  * 
	  * 功能描述: 批量删除银行基础信息
	  * 
	  * @param ids
	  * @return int
     * @version V1.0.0
     * @author 徐大伟
	  */
	public int batchDeleteBasicBankInfo(String ids) {
	    String[] idArray= ids.split(",");
	    List<Object> idsList=new ArrayList<Object>();
	    for(String item : idArray){
	        idsList.add(item);
	    }
	    Map<String,Object> paraMap = new HashMap<String,Object>();
	    paraMap.put("ids",idsList);
	    int r1=basicBankInfoDao.batchDeleteBasicBankInfo(paraMap);
	    return r1;
	}
	
	/**
	 * 
	 * 功能描述:根据银行卡号获取所属银行 
	 * 
	 * @param cardNo
	 * @return BasicBankInfo
	 * @version 1.0.0
	 * @author 徐大伟
	 */
    public BasicBankInfo getBankByCardNo(String cardNo) {
        return basicBankInfoDao.getBankByCardNo(cardNo);
    }
}
