package com.ync365.jrpt.business.biz;

import com.ync365.jrpt.business.dao.AreasDao;
import com.ync365.jrpt.business.dao.entity.Areas;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author yangwenqi
 * @version v1.0
 */
@Service
public class AreasBiz
{

    @Autowired
    private AreasDao areasDao;

    /**
     * 获取全部省
     *
     * @return
     */
    public List<Areas> findAllProvince()
    {
        return areasDao.findAreasByLevelAndParentId(1, "0");
    }

    /**
     * 获取指定省份的所有市
     *
     * @param provinceId
     * @return
     */
    public List<Areas> findCityByProvinceId(String provinceId)
    {
        return areasDao.findAreasByLevelAndParentId(2, provinceId);
    }

    /**
     * 获取指定市下的所有区或县
     *
     * @param cityId
     * @return
     */
    public List<Areas> findCountyByCityId(String cityId)
    {
        return areasDao.findAreasByLevelAndParentId(3, cityId);
    }

    /**
     * 获取指定区或县下的所有乡镇街道
     *
     * @param countyId
     * @return
     */
    public List<Areas> findTownByCountyId(String countyId)
    {
        return areasDao.findAreasByLevelAndParentId(4, countyId);
    }

    /**
     * 获取指定乡镇街道下的所有社区及村庄
     *
     * @param townId
     * @return
     */
    public List<Areas> findVillageByTownId(String townId)
    {
        return areasDao.findAreasByLevelAndParentId(5, townId);
    }

    /**
     * 根据子节点查询自己以及自己所有的上级节点
     *
     * @param childrenId
     * @return
     */
    public List<Areas> findAllParentAreasByChild(String childrenId)
    {
        return areasDao.findAllParentAreasByChild(childrenId);
    }

}
