package com.ync365.jrpt.business.biz;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ync365.jrpt.business.dao.SysResourceDao;
import com.ync365.jrpt.business.dao.SysRoleDao;
import com.ync365.jrpt.business.dao.SysUserDao;
import com.ync365.jrpt.business.dao.entity.SysResource;
import com.ync365.jrpt.business.dao.entity.SysUser;
/**
 * 
 * 功能描述: Shiro管理
 * 
 * @version 1.0.0
 * @author 徐大伟
 */
@Service
public class AdminShiroBiz {
	@Autowired
	private SysUserDao sysUserDao;
	@Autowired
	private SysResourceDao sysResourceDao;
	@Autowired
	private SysRoleDao sysRoleDao;
	
	/**
	 * 查找所有资源
	 * @return
	 */
	public List<SysResource>  findAllResource(){
		return sysResourceDao.findAllResource();
	}
	
	/**
     * 根据角色Id查找资源数据
     * @param roleId
     * @return
     */
	public List<SysResource> findResourceByRoleId(int roleId){
		return sysResourceDao.findResourceByRoleId(roleId);
	}
	
	 /**
     * 根据用户名查找用户
     * @param userName 用户名
     * @return
     */
	public SysUser findByUsername(String userName){
		if(StringUtils.isBlank(userName)){
			return null;
		}
		return sysUserDao.findByUserName(userName);
	}
}
