package com.jxwk.auth.web.shiro;

import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.springframework.beans.factory.annotation.Autowired;

import com.jxwk.auth.business.biz.AdminShiroBiz;
import com.jxwk.auth.business.dao.entity.SysUser;

/**
 * 
 * apache shiro 的身份验证类
 * 
 *
 */
public class JdbcAuthenticationRealm extends AuthorizationRealm{
	@Autowired
	private AdminShiroBiz adminShiroBiz;

	/**
	 * 用户登录的身份验证方法
	 * 
	 */
	protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
		UsernamePasswordToken usernamePasswordToken = (UsernamePasswordToken) token;

		String username = usernamePasswordToken.getUsername();

		SysUser user = adminShiroBiz.findByUsername(username);

		if (user == null) {
			throw new UnknownAccountException("用户名或密码不正确");// 没找到帐号
		}

		if (Boolean.TRUE.equals(user.getLocked())) {
			throw new LockedAccountException("账号已锁定"); // 帐号锁定
		}
		if(StringUtils.isBlank(String.valueOf(usernamePasswordToken.getPassword()))){
			throw new AccountException("用户名或密码不正确");// 没找到帐号
		}
		ShiroUser shiroUser = new ShiroUser(user);
		
		return new SimpleAuthenticationInfo(shiroUser,user.getPassword(),getName());
	}
	

}
