package com.jxwk.auth.web.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.jxwk.auth.business.biz.SysRoleBiz;
import com.jxwk.auth.business.biz.SysUserBiz;
import com.jxwk.auth.business.dao.entity.SysUser;
import com.jxwk.auth.business.pagination.Page;
import com.jxwk.auth.business.pagination.PageRequest;
import com.jxwk.auth.web.controller.result.FailMsg;
import com.jxwk.auth.web.controller.result.Msg;
import com.jxwk.auth.web.controller.result.SuccessMsg;
import com.jxwk.auth.web.resolver.annotation.GridParam;
import com.jxwk.auth.web.shiro.util.ShiroUserUtils;

/**
 * 系统用户管理
 *
 */
@Controller("authSysUserController")
@RequestMapping("/user")
public class SysUserController extends BaseController{
	private static final Logger  logger  = LoggerFactory.getLogger(SysUserController.class);
	@Autowired
	private SysUserBiz sysUserBiz;

	@Autowired
	private SysRoleBiz sysRoleBiz;

	@RequestMapping
	public String index() {
		return "user/list";
	}

	/**
	 * 列表处理
	 */
	@RequestMapping("/list")
	@ResponseBody
	public Page<Map<String, Object>> list(String userName,String realName,String mobile,String userType,
			@GridParam PageRequest pageRequest) {
		return sysUserBiz.findUserList(userName,realName, mobile,userType,  pageRequest);
	}

	/**
	 * 添加界面
	 */
	@RequestMapping("/add")
	public String add() {
		return "user/add";
	}

	/**
	 * 添加操作
	 * 
	 * @param userName
	 * @param password
	 * @param realName
	 * @param mobile
	 * @param roleId
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ResponseBody
	public Object save(@RequestParam(required = true) String userName,
			@RequestParam(required = true) String mobile,
			@RequestParam(required = true) String password,
			@RequestParam(required = true) String realName,
			@RequestParam(required = true) String roleId) {
		try {
			SysUser oUser = sysUserBiz.findByUsername(userName);
			if (oUser != null) {
				return new FailMsg("用户已存在", null);
			}
			int uSize = sysUserBiz.countUserByMobile(mobile);

			if (uSize > 0) {
				return new FailMsg("联系电话已存在", null);
			}
			SysUser user = new SysUser();
			
			user.setPassword(password);
			user.setUserName(userName);
			user.setLocked(false);
			user.setMobile(mobile);
			user.setRealName(realName);
			user.setRoleId(roleId);
			sysUserBiz.insert(user);
			return new SuccessMsg("保存成功", null);
		} catch (Exception e) {
			e.printStackTrace();
			return new FailMsg("保存失败", null);
		}
	}

	/**
	 * 修改界面
	 */
	@RequestMapping("/edit")
	public String edit(Integer id, HttpServletRequest request) {
		SysUser sysUser = sysUserBiz.selectByPrimaryKey(id);
		request.setAttribute("sysUser", sysUser);
		return "user/edit";
	}

	@RequestMapping(value = "/update", method = RequestMethod.POST)
	@ResponseBody
	public Object update(
			@RequestParam(required = true) Integer id,
			@RequestParam(required = true) String mobile,
			@RequestParam(required = true) String realName,
			@RequestParam(required = true) String roleId,
			@RequestParam(required = true) Boolean locked) {

		try {
			SysUser user = sysUserBiz.selectByPrimaryKey(id);
			if (user == null) {
				return new FailMsg("用户不存在", null);
			}
			if(!StringUtils.equals(user.getMobile(), mobile)){
				int uSize = sysUserBiz.countUserByMobile(mobile);
				if (uSize > 0) {
					return new FailMsg("联系电话已存在", null);
				}
			}
			user.setLocked(locked);
			user.setMobile(mobile);
			user.setRealName(realName);
			user.setRoleId(roleId);
			sysUserBiz.updateUser(user);
//			ShiroUserUtils.clearCachedAuthenticationInfo(user.getUserName());
			return new SuccessMsg("保存成功", null);
		} catch (Exception e) {
			e.printStackTrace();
			return new FailMsg("保存失败", null);
		}
	}

	/**
	 * 删除用户
	 * 
	 * @param userName
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public Object delete(Integer id) {
		try {
			if(sysUserBiz.removeUser(id));
			return new SuccessMsg("删除成功", null);
		} catch (Exception e) {
			logger.info("删除用户失败！");
			return new FailMsg("删除失败", null);
		}
	}

	/**
	 * 获取系统用户的角色，包括系统管理员 和财务管理员类型的
	 * 
	 * @return
	 */
	@RequestMapping(value = "/getSysUserRoles", method = RequestMethod.POST)
	@ResponseBody
	public Object getSysUserRoles(String type) {
		List<String> userTypes = new ArrayList<String>();
		userTypes.add(type);
		return sysRoleBiz.findRolesByUserTypes(userTypes);
	}
	@RequestMapping(value = "/updatePwd", method = RequestMethod.POST)
	@ResponseBody
	public Object updatePwd(@RequestParam(required=true)int id) {
		try {
			SysUser user =sysUserBiz.selectByPrimaryKey(id);
			
			SuccessMsg success = new SuccessMsg(sysUserBiz.updateRandomPwd(id),null);
			ShiroUserUtils.clearCachedAuthenticationInfo(user.getUserName());
			return success;
		} catch (Exception e) {
			logger.error("更新密码出错",e);
			return new FailMsg("更新密码出错",null);
		}
	}
	@RequestMapping("toChangePwd")
	public String toChangePwd(){
		return "user/changePwd";
	}
	@RequestMapping("changePwd")
	@ResponseBody
	public Object changePwd(HttpServletRequest request){
		Msg msg = new FailMsg("修改密码失败");
		SysUser su = ShiroUserUtils.getCurrentSysUser();
		String oldPwd = request.getParameter("oldPwd");
		String newPwd=request.getParameter("newPwd");
		if(StringUtils.isNotBlank("oldPwd")&&StringUtils.isNotBlank(newPwd)){
			String _oldPwd = encryptPwd(oldPwd);
			if(_oldPwd.equals(su.getPassword())){
				if(sysUserBiz.updatePwd(su.getId(), newPwd)>0){
					ShiroUserUtils.clearCachedAuthenticationInfo(su.getUserName());
					return new SuccessMsg("修改密码成功！", null);
				}else{
					logger.info("用户 ["+su.getUserName()+"]修改密码失败！");
					msg.setMsg("密码修改失败！");
				}
			}else{
				msg.setMsg("原密码错误！");
			}
		}else{
			msg.setMsg("密码不能为空！");
		}
		return msg;
	}
}
