package com.jxwk.auth.web.config;

import java.io.Serializable;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
/**
 * 
 * 功能描述:系统配置类 
 * 
 * @version 1.0.0
 * @author 徐大伟
 */
@Component
public class SystemConfig implements Serializable{

    private static final long serialVersionUID = -2366104287436119840L;

    @Value("${login.style}")  
    private String loginStyle;  
    
    @Value("${admin.logo.path}")  
    private String adminLogoPath;  
    
    @Value("${admin.frame.style}")  
    private String adminFrameStyle;
    
    @Value("${admin.frame.index.url}")  
    private String adminFrameIndexUrl;
    
    @Value("${app.name}")  
    private String appName;
    
    @Value("${app.copyright}")  
    private String appCopyright;
     
    public String getLoginStyle() {
        return loginStyle;
    }

    public String getAdminLogoPath() {
        return adminLogoPath;
    }

    public static long getSerialversionuid() {
        return serialVersionUID;
    }

    public String getAdminFrameStyle() {
        return adminFrameStyle;
    }

    public String getAdminFrameIndexUrl() {
        return adminFrameIndexUrl;
    }

    public String getAppName() {
        return appName;
    }

    public String getAppCopyright() {
        return appCopyright;
    }
    
    
}
