package com.jxwk.auth.business.dao;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import com.jxwk.auth.business.dao.entity.SysRole;

public interface SysRoleDao {
	/**
	 * 根据角色名或用户类型获取角色集合
	 * @param name 角色名 模糊
	 * @param userType 用户类型
	 * @param offset 起始行号
	 * @param limit 结果集数量
	 * @return 角色集合
	 */
	List<SysRole> findSysRolesByNameAndUserType(@Param("name") String name, @Param("userType")String userType,@Param("offset") Integer offset,@Param("limit") Integer limit);
	/**
	 * 统计根据角色名或用户类型获取角色集合数量
	 * @param name 角色名 模糊
	 * @param userType 用户类型
	 * @param offset 起始行号
	 * @param limit 结果集数量
	 * @return 角色集合
	 */
	int countSysRolesByNameAndUserType(@Param("name") String name, @Param("userType")String userType,@Param("offset") Integer offset,@Param("limit") Integer limit);
	
	/**
	 * 查找所有资源并根据角色Id将已关联的资源  checked =1 
	 * @param roleId 
	 * @return 集合
	 */
	public List<Map<String,Object>> findResourcesByRoleId(@Param("roleId")int roleId);
	
	/**
	 * 保存角色对象
	 * @param sysRole
	 * @return
	 */
	public int saveRole(SysRole sysRole);
	
	
	/**
	 * 保存角色和资源的映射关系
	 * @return 记录数
	 */
	public int saveRoleMRessource(@Param("resourceIds")List<String> resourceIds,@Param("roleId") int roleId);
	/**
	 * 删除角色对应的资源
	 * @param roleId
	 * @return
	 */
 	public int delRoleByRoleId(@Param("roleId") int roleId);
 	
 	public SysRole findOneById(@Param("id") int id);
 	
 	/**
	 * 更新角色对象
	 * @param sysRole
	 * @return
	 */
	public int updateRole(SysRole sysRole);
	
	
	public List<SysRole> findRolesByUserTypes(@Param("userTypes") List<String> userTypes);
	
	public List<SysRole> findAllRole();
 	
}