/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.auth.web.shiro;

import com.jxwk.auth.business.biz.AdminShiroBiz;
import com.jxwk.auth.business.dao.entity.SysResource;
import com.jxwk.auth.web.shiro.Menu;
import com.jxwk.auth.web.shiro.ShiroUser;
import com.jxwk.auth.web.shiro.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public abstract class AuthorizationRealm
extends AuthorizingRealm {
    @Autowired
    private AdminShiroBiz adminShiroBiz;
    private List<String> defaultPermission = new ArrayList<String>();

    public void setDefaultPermissionString(String defaultPermissionString) {
        Object[] perms = StringUtils.split((String)defaultPermissionString, (String)",");
        CollectionUtils.addAll(this.defaultPermission, (Object[])perms);
    }

    public void setDefaultPermission(List<String> defaultPermission) {
        this.defaultPermission = defaultPermission;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        ShiroUser model = (ShiroUser)principals.oneByType(ShiroUser.class);
        Assert.notNull((Object)model, (String)"\u627e\u4e0d\u5230principals\u4e2d\u7684ShiroUser");
        List<SysResource> resources = this.adminShiroBiz.findResourceByRoleId(NumberUtils.toInt((String)model.getSysUser().getRoleId()));
        List<String> permissions = this.getPermsValue(resources);
        if (CollectionUtils.isNotEmpty(this.defaultPermission)) {
            CollectionUtils.addAll(permissions, this.defaultPermission.iterator());
        }
        HashSet<String> set = new HashSet<String>(permissions);
        if (!CollectionUtils.isEmpty(permissions)) {
            info.setStringPermissions(set);
        }
        model.setMenus(this.extractMenusFromResources(resources));
        return info;
    }

    public List<Menu> extractMenusFromResources(List<SysResource> list) {
        ArrayList<Menu> menus = new ArrayList<Menu>();
        HashMap tempMap = new HashMap();
        Menu menu = null;
        ArrayList<Menu> childList = null;
        for (SysResource resource : list) {
            if (null == resource || resource.getType() != 1) continue;
            menu = new Menu(resource.getId(), resource.getName(), StringUtils.replace((String)resource.getUrl(), (String)"**", (String)""), null);
            if (resource.getParentId() == 0) {
                menus.add(menu);
                continue;
            }
            if (null == tempMap.get(resource.getParentId())) {
                childList = new ArrayList<Menu>();
                childList.add(menu);
                tempMap.put(resource.getParentId(), childList);
                continue;
            }
            ((List)tempMap.get(resource.getParentId())).add(menu);
        }
        for (Menu ms : menus) {
            if (tempMap.get(ms.getId()) == null) continue;
            ms.setChildren((List)tempMap.get(ms.getId()));
        }
        return menus;
    }

    private List<String> getPermsValue(List<SysResource> collection) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (SysResource obj : collection) {
                if (null == obj || !StringUtils.isNotBlank((CharSequence)obj.getPermission())) continue;
                result.add(this.getValueForPattern(obj.getPermission()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return result;
    }

    private String getValueForPattern(String str) {
        String res = null;
        Pattern pattern = Pattern.compile("perms\\[(.*?)\\]");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            res = matcher.group(1);
        }
        return res;
    }
}

