/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.auth.web.resolver;

import com.jxwk.auth.business.pagination.PageRequest;
import com.jxwk.auth.web.resolver.annotation.GridParam;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageableHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger logger = LoggerFactory.getLogger(PageableHandlerMethodArgumentResolver.class);
    private static final String PARAM_PAGE_NUM = "page";
    private static final String PARAM_PAGE_SIZE = "rows";

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(GridParam.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        try {
            int pageNum = NumberUtils.toInt((String)webRequest.getParameter(PARAM_PAGE_NUM));
            int pageSize = NumberUtils.toInt((String)webRequest.getParameter(PARAM_PAGE_SIZE));
            return new PageRequest(pageNum, pageSize);
        }
        catch (Exception e) {
            logger.error("\u6784\u5efa\u5206\u9875\u8bf7\u6c42\u5bf9\u8c61\u51fa\u9519", (Throwable)e);
            return new PageRequest();
        }
    }
}

