/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.auth.business.biz;

import com.jxwk.auth.business.dao.SysResourceDao;
import com.jxwk.auth.business.dao.SysRoleDao;
import com.jxwk.auth.business.dao.entity.SysRole;
import com.jxwk.auth.business.pagination.Page;
import com.jxwk.auth.business.pagination.PageBuilder;
import com.jxwk.auth.business.pagination.PageRequest;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="authSysRoleBiz")
public class SysRoleBiz {
    @Autowired
    private SysRoleDao sysRoleDao;
    @Autowired
    private SysResourceDao sysResourceDao;

    public Page<SysRole> findPageByNameAndUserType(String name, String userType, PageRequest pageRequest) {
        List<SysRole> result = this.sysRoleDao.findSysRolesByNameAndUserType(name, userType, pageRequest.getOffset(), pageRequest.getPageSize());
        int total = this.sysRoleDao.countSysRolesByNameAndUserType(name, userType, pageRequest.getOffset(), pageRequest.getPageSize());
        return PageBuilder.buildPage(pageRequest, result, total);
    }

    public List<Map<String, Object>> findResourcesByRoleId(Integer roleId) {
        return this.sysRoleDao.findResourcesByRoleId(roleId);
    }

    @Transactional
    public void saveRole(String name, String userType, List<String> resourceIds) {
        SysRole role = new SysRole();
        role.setName(name);
        role.setUserType(userType);
        this.sysRoleDao.saveRole(role);
        this.sysRoleDao.saveRoleMRessource(resourceIds, role.getId());
    }

    @Transactional
    public void updateRole(Integer roleId, String name, String userType, List<String> resourceIds) {
        SysRole role = new SysRole();
        role.setId(roleId);
        role.setName(name);
        this.sysRoleDao.updateRole(role);
        this.sysResourceDao.delRoleMRessourceByRoleId(roleId);
        this.sysRoleDao.saveRoleMRessource(resourceIds, role.getId());
    }

    public SysRole findOneById(int roleId) {
        return this.sysRoleDao.findOneById(roleId);
    }

    @Transactional
    public void deleteRoleAndRoleResourceByRoleId(int roleId) {
        this.sysRoleDao.delRoleByRoleId(roleId);
        this.sysResourceDao.delRoleMRessourceByRoleId(roleId);
    }

    public List<SysRole> findRolesByUserTypes(List<String> userType) {
        return this.sysRoleDao.findAllRole();
    }
}

