package com.jxwk.auth.web.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.jxwk.auth.business.biz.SysResourceBiz;
import com.jxwk.auth.business.biz.SysRoleBiz;
import com.jxwk.auth.business.biz.SysUserBiz;
import com.jxwk.auth.business.dao.entity.SysResource;
import com.jxwk.auth.business.dao.entity.SysRole;
import com.jxwk.auth.business.enums.UserTypeEnum;
import com.jxwk.auth.business.pagination.Page;
import com.jxwk.auth.business.pagination.PageRequest;
import com.jxwk.auth.web.controller.result.FailMsg;
import com.jxwk.auth.web.controller.result.SuccessMsg;
import com.jxwk.auth.web.resolver.annotation.GridParam;
import com.jxwk.auth.web.shiro.Menu;
import com.jxwk.auth.web.shiro.util.ShiroUserUtils;
/**
 * 角色管理
 *
 */
@Controller("authSysRoleController")
@RequestMapping("/role")
public class SysRoleController {
	private static final Logger      logger        = LoggerFactory.getLogger(SysRoleController.class);
	@Autowired 
	private SysRoleBiz sysRoleBiz;
	@Autowired 
	private SysResourceBiz sysResourceBiz;
	@Autowired 
	private SysUserBiz sysUserBiz;
	
	
	@RequestMapping
	public String index(){
		return "role/list";
	}
	/**
	 * 列表处理
	 */
	@RequestMapping("/list")
	@ResponseBody
	public Page<SysRole> list(String roleName,String userType,@GridParam PageRequest pageRequest){
		return sysRoleBiz.findPageByNameAndUserType(roleName, userType, pageRequest);
	}
	@RequestMapping("/add")
	public ModelAndView add(){
	    ModelAndView mav = new ModelAndView("role/add");
	    mav.addObject("roleId",ShiroUserUtils.getCurrentSysUser().getRoleId());
		return mav;
	}
	@RequestMapping("/getResources")
	@ResponseBody
	public Object getResources(Integer roleId){
		if(roleId==null){
		    return  sysResourceBiz.findAllResource();
//			return extractMenusFromResources(sysResourceBiz.findAllResource());
		}else{
		    return sysRoleBiz.findResourcesByRoleId(roleId);	
//			return extractMenusFromMap(sysRoleBiz.findResourcesByRoleId(roleId));	
		}
		
	}
	
	@RequestMapping(value="/save", method = RequestMethod.POST )
	@ResponseBody
	public Object save(Integer roleId ,@RequestParam(required=true) String name,  String userType,String ids){
		List<String> resourceIds =new ArrayList<String>();
		try {
			CollectionUtils.addAll(resourceIds, StringUtils.split(ids, ","));
			if(roleId==null){
				sysRoleBiz.saveRole(name, userType, resourceIds);
			}else{
				sysRoleBiz.updateRole(roleId,name, userType, resourceIds);
			}
			return new SuccessMsg("保存成功",null);
		} catch (Exception e) {
			logger.error("保存出错",e);
			return new FailMsg("保存失败",null);
		}
	
	}
	
	@RequestMapping("/edit")
	public String edit(@RequestParam(required=true)Integer roleId,HttpServletRequest request){
		SysRole role =sysRoleBiz.findOneById(roleId);
		for(UserTypeEnum ute:UserTypeEnum.values()){
			if(StringUtils.equals(ute.getValue(),role.getUserType())){
				request.setAttribute("userTypeName",ute.getName() );
			}
		}
		request.setAttribute("role", role);
		return "role/edit";
	}
	
	@RequestMapping(value="/delete", method = RequestMethod.POST)
	@ResponseBody
	public Object delete(@RequestParam(required=true)Integer roleId,HttpServletRequest request){
		int size=sysUserBiz.countSysUserByRoleId(roleId);
		if(size>0){
			return new FailMsg("该角色已有绑定用户,请先解绑",null);
		}
		try {
			sysRoleBiz.deleteRoleAndRoleResourceByRoleId(roleId);
			return new SuccessMsg("删除成功",null);
		} catch (Exception e) {
			logger.error("{} 角色已有绑定用户,请先解绑",roleId,e);
			return new FailMsg("该角色已有绑定用户,请先解绑",null);
		}
	}
}
