package com.jxwk.auth.web.controller;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.jxwk.auth.business.biz.SysUserBiz;
import com.jxwk.auth.business.dao.entity.SysUser;
import com.jxwk.auth.business.util.CaptchaUtils;
import com.jxwk.auth.web.controller.result.FailMsg;
import com.jxwk.auth.web.controller.result.SuccessMsg;
import com.jxwk.auth.web.shiro.filter.CaptchaAuthenticationFilter;
import com.jxwk.auth.web.shiro.util.ShiroUserUtils;

@Controller("authMainController")
@RequestMapping
public class MainController {
    
    @Value("${login.style}")  
    private String loginStyle;  
    
    @Value("${admin.frame.style}")  
    private String adminFrameStyle;
	@Autowired
	private SysUserBiz userBiz;
	@RequestMapping
	public String main(){
    	if(ShiroUserUtils.isAuthenticated()){
    		return "redirect:/index";
    	}else{
    		return "redirect:/login";
    	}
    	
    }
	/**
	 * @return String
	 */
	@RequestMapping("/login")
	public String login(HttpServletRequest request,HttpServletResponse response) {
		String msg = (String)request.getAttribute("shiroLoginFailure");
		if(StringUtils.length(msg)>=15){//防止出现未捕获的错误信息，提示在页面
			request.setAttribute("errorMsg", "用户名或密码错误");
		}else{
			request.setAttribute("errorMsg", msg);
		}
		if (!SecurityUtils.getSubject().isAuthenticated()) {
			response.setStatus(901);
			return "system/login/theme/"+loginStyle+"/login";
		}
		return "redirect:index";
	}
	@RequestMapping("/welcome")
	public String welcome() {
		return "welcome";
	}
	@RequestMapping("/menus")
	@ResponseBody
	public Object menus() {
		return ShiroUserUtils.getCurrentShiroUser().getMenus();
	}
	@RequestMapping("/get-captcha")
	public void getCaptcha(HttpSession session,HttpServletResponse response) throws IOException {
		
		HttpHeaders headers = new HttpHeaders();
		headers.setContentType(MediaType.IMAGE_JPEG);
		
		ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		String captcha = CaptchaUtils.getCaptcha(70, 32, 4, outputStream).toLowerCase();
		
		session.setAttribute(CaptchaAuthenticationFilter.DEFAULT_CAPTCHA_PARAM,captcha);
		byte[] bs = outputStream.toByteArray();
		OutputStream os =response.getOutputStream();
		os.write(bs);
		outputStream.close();
		os.flush();
	}
	
    /**
     * 默认进入首页的C
     */
    @RequestMapping("/index")
    public String index(){
    	return "system/frame/theme/"+adminFrameStyle+"/index";
    }
    
    /**
     * 默认进入首页的C
     */
    @RequestMapping("/workbench")
    public String workbench(){
        return "system/frame/theme/"+adminFrameStyle+"/workbench";
    }
	
    @RequestMapping("/unauthorized")
    public String unauthorized(HttpServletRequest request,HttpServletResponse response){
    	response.setStatus(902);    	
    	return "unauthorized";
    }
    
    @RequestMapping("/personal")
    public String personal(HttpServletRequest request,HttpServletResponse response){
    	SysUser userSession=ShiroUserUtils.getCurrentShiroUser().getSysUser();
    	SysUser user=userBiz.selectByPrimaryKey(userSession.getId());
    	request.setAttribute("user", user);
    	return "/user/personal";
    }

	@RequestMapping(value = "/updateUserInformation", method = RequestMethod.POST)
	@ResponseBody
	public Object update(SysUser user,String oldPassword){
		try {
			int result = userBiz.checkAndSaveUser(user,oldPassword);
			if(result==5){
				return new FailMsg("手机号已存在，请更改",null);
			}else if(result==6){
				return new FailMsg("旧密码输入错误",null);
			}
		} catch (Exception e) {
			return new FailMsg("更新失败",null);
		}
		ShiroUserUtils.clearCachedAuthenticationInfo(user.getUserName());
		return new SuccessMsg("更新成功",null);
	}
    @RequestMapping("/message")
    public String message(){
    	return "/user/messageList";
    }

}
