package com.jxwk.auth.business.biz;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jxwk.auth.business.dao.SysResourceDao;
import com.jxwk.auth.business.dao.SysRoleDao;
import com.jxwk.auth.business.dao.SysUserDao;
import com.jxwk.auth.business.dao.entity.SysResource;
import com.jxwk.auth.business.dao.entity.SysUser;
/**
 * 
 * 功能描述: Shiro管理
 * 
 * @version 1.0.0
 * @author 徐大伟
 */
@Service("authAdminShiroBiz")
public class AdminShiroBiz {
	@Autowired
	private SysUserDao sysUserDao;
	@Autowired
	private SysResourceDao sysResourceDao;
	@Autowired
	private SysRoleDao sysRoleDao;
	
	/**
	 * 查找所有资源
	 * @return
	 */
	public List<SysResource>  findAllResource(){
		return sysResourceDao.findAllResource();
	}
	
	/**
     * 根据角色Id查找资源数据
     * @param roleId
     * @return
     */
	public List<SysResource> findResourceByRoleId(int roleId){
		return sysResourceDao.findResourceByRoleId(roleId);
	}
	
	 /**
     * 根据用户名查找用户
     * @param userName 用户名
     * @return
     */
	public SysUser findByUsername(String userName){
		if(null==userName || "".equals(userName)){
			return null;
		}
		return sysUserDao.findByUserName(userName);
	}
}
