/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.auth.web.shiro.filter;

import com.jxwk.auth.web.shiro.exception.CaptchaErrorException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;

public class CaptchaAuthenticationFilter
extends FormAuthenticationFilter {
    public static final String DEFAULT_CAPTCHA_PARAM = "captcha";
    private static final String DEFAULT_LOGIN_INCORRECT_NUMBER_KEY_ATTRIBUTE = "incorrectNumber";
    private String captchaParam = "captcha";
    private String sessionCaptchaKeyAttribute = "captcha";
    private String loginIncorrectNumberKeyAttribute = "incorrectNumber";
    private Integer allowIncorrectNumber = 1;

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        Session session = CaptchaAuthenticationFilter.createSessionIfNull();
        Integer number = (Integer)session.getAttribute((Object)this.getLoginIncorrectNumberKeyAttribute());
        if (number == null) {
            number = new Integer(1);
            session.setAttribute((Object)this.getLoginIncorrectNumberKeyAttribute(), (Object)number);
        }
        if (number > this.getAllowIncorrectNumber()) {
            String currentCaptcha = (String)session.getAttribute((Object)this.getSessionCaptchaKeyAttribute());
            String submitCaptcha = this.getCaptcha(request);
            if (StringUtils.isEmpty((CharSequence)submitCaptcha) || !StringUtils.equals((CharSequence)currentCaptcha, (CharSequence)submitCaptcha.toLowerCase())) {
                return this.onLoginFailure(this.createToken(request, response), new CaptchaErrorException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e"), request, response);
            }
        }
        return super.executeLogin(request, response);
    }

    protected void setFailureAttribute(ServletRequest request, AuthenticationException ae) {
        if (ae instanceof IncorrectCredentialsException) {
            request.setAttribute(this.getFailureKeyAttribute(), (Object)"\u767b\u5f55\u5e10\u53f7\u5bc6\u7801\u4e0d\u6b63\u786e");
        } else if (ae instanceof CaptchaErrorException) {
            request.setAttribute(this.getFailureKeyAttribute(), (Object)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        } else {
            request.setAttribute(this.getFailureKeyAttribute(), (Object)ae.getMessage());
        }
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        Session session = CaptchaAuthenticationFilter.getSession();
        Integer number = (Integer)session.getAttribute((Object)this.getLoginIncorrectNumberKeyAttribute());
        number = number + 1;
        session.setAttribute((Object)this.getLoginIncorrectNumberKeyAttribute(), (Object)number);
        return super.onLoginFailure(token, e, request, response);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        Session session = CaptchaAuthenticationFilter.getSession();
        session.removeAttribute((Object)this.getLoginIncorrectNumberKeyAttribute());
        session.setAttribute((Object)"current_user", subject.getPrincipal());
        return super.onLoginSuccess(token, subject, request, response);
    }

    public void setCaptchaParam(String captchaParam) {
        this.captchaParam = captchaParam;
    }

    public String getCaptchaParam() {
        return this.captchaParam;
    }

    public void setSessionCaptchaKeyAttribute(String sessionCaptchaKeyAttribute) {
        this.sessionCaptchaKeyAttribute = sessionCaptchaKeyAttribute;
    }

    public String getSessionCaptchaKeyAttribute() {
        return this.sessionCaptchaKeyAttribute;
    }

    public String getLoginIncorrectNumberKeyAttribute() {
        return this.loginIncorrectNumberKeyAttribute;
    }

    public void setLoginIncorrectNumberKeyAttribute(String loginIncorrectNumberKeyAttribute) {
        this.loginIncorrectNumberKeyAttribute = loginIncorrectNumberKeyAttribute;
    }

    public String getCaptcha(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)this.getCaptchaParam());
    }

    public Integer getAllowIncorrectNumber() {
        return this.allowIncorrectNumber;
    }

    public void setAllowIncorrectNumber(Integer allowIncorrectNumber) {
        this.allowIncorrectNumber = allowIncorrectNumber;
    }

    public static Session createSessionIfNull() {
        Session session = CaptchaAuthenticationFilter.getSession();
        if (session == null) {
            session = CaptchaAuthenticationFilter.getSession(true);
        }
        return session;
    }

    public static Session getSession() {
        return CaptchaAuthenticationFilter.getSession(false);
    }

    public static Session getSession(boolean create) {
        return SecurityUtils.getSubject().getSession(create);
    }
}

