/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.auth.web.shiro;

import com.jxwk.auth.business.biz.AdminShiroBiz;
import com.jxwk.auth.business.dao.entity.SysUser;
import com.jxwk.auth.web.shiro.AuthorizationRealm;
import com.jxwk.auth.web.shiro.ShiroUser;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.springframework.beans.factory.annotation.Autowired;

public class JdbcAuthenticationRealm
extends AuthorizationRealm {
    @Autowired
    private AdminShiroBiz adminShiroBiz;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken usernamePasswordToken = (UsernamePasswordToken)token;
        String username = usernamePasswordToken.getUsername();
        SysUser user = this.adminShiroBiz.findByUsername(username);
        if (user == null) {
            throw new UnknownAccountException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        if (Boolean.TRUE.equals(user.getLocked())) {
            throw new LockedAccountException("\u8d26\u53f7\u5df2\u9501\u5b9a");
        }
        if (StringUtils.isBlank((CharSequence)String.valueOf(usernamePasswordToken.getPassword()))) {
            throw new AccountException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        ShiroUser shiroUser = new ShiroUser(user);
        return new SimpleAuthenticationInfo((Object)shiroUser, (Object)user.getPassword(), this.getName());
    }
}

