package com.jxwk.auth.web.shiro.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jxwk.auth.business.dao.entity.SysUser;
import com.jxwk.auth.web.shiro.ShiroUser;

/**
 *  系统安全用户工具类
 * @author
 *
 */
public class ShiroUserUtils {
	
	private static final Logger  logger  = LoggerFactory.getLogger(ShiroUserUtils.class);
	/**
	 * 获取当前ShiroUser
	 * @return
	 */
	public static ShiroUser getCurrentShiroUser(){
		Object obj =getSubject().getPrincipal();
		if(obj==null){
			return null;
		}
		return (ShiroUser)obj;
	}
	/**
	 * 获取当前系统用户
	 * @return
	 */
	public static SysUser getCurrentSysUser(){
		ShiroUser shiroUser =getCurrentShiroUser();
		if(shiroUser ==null){
			return null;
		}
		return shiroUser.getSysUser();
	}
	
	public static Subject  getSubject(){
		return SecurityUtils.getSubject();
	}
	/**
	 * 判断当前用户否已经过身份验证
	 * @return true  已验证   false  未验证
	 */
	public static boolean isAuthenticated(){
		return getSubject().isAuthenticated();
	}
	public static  Session getSession(){
		return getSubject().getSession();
	}
	
	public static void clearCachedAuthenticationInfo(String loginName){
		if(StringUtils.isBlank(loginName)){
			return ;
		}
		try {
			RealmSecurityManager securityManager =  (RealmSecurityManager) SecurityUtils.getSecurityManager();  
			CacheManager manager =securityManager.getCacheManager();
			securityManager.logout(getSubject());
			Cache<Object, Object> cache = manager.getCache("ncbqs_admin_shiroAuthorizationCache");
			cache.clear();
		} catch (UnavailableSecurityManagerException e) {
			logger.error("清除用户认证信息出错",e);
		} catch (CacheException e) {
			logger.error("清除用户认证信息出错",e);
		}
	}


}
