package com.jxwk.auth.web.shiro;

import java.io.Serializable;
import java.util.List;

import org.apache.shiro.crypto.hash.SimpleHash;

import com.jxwk.auth.business.dao.entity.SysResource;
import com.jxwk.auth.business.dao.entity.SysUser;

public class ShiroUser implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	// 当前用户
	private SysUser sysUser;
	// 当前用户的授权资源集合
	private List<SysResource> authorizationInfo;
	// 当前用户的菜单集合
	private List<Menu> menus;

	public ShiroUser() {

	}

	public ShiroUser(SysUser sysUser) {
		this.sysUser = sysUser;
	}
	public ShiroUser(SysUser sysUser,List<SysResource> authorizationInfo, List<Menu> menus) {
		this.sysUser = sysUser;
		this.authorizationInfo = authorizationInfo;
		this.menus = menus;
	}

	public SysUser getSysUser() {
		return sysUser;
	}

	public void setSysUser(SysUser sysUser) {
		this.sysUser = sysUser;
	}
	public int getId(){
		return sysUser.getId();
	}
	
	public List<SysResource> getAuthorizationInfo() {
		return authorizationInfo;
	}

	public void setAuthorizationInfo(List<SysResource> authorizationInfo) {
		this.authorizationInfo = authorizationInfo;
	}



	public List<Menu> getMenus() {
		return menus;
	}

	public void setMenus(List<Menu> menus) {
		this.menus = menus;
	}

	@Override
	public String toString() {
		return sysUser.getRealName();
	}
	public static void main(String[] args) {
		String temp = new SimpleHash("MD5","123456").toHex();
		System.out.println(temp);
	}

}
