package com.jxwk.auth.web.shiro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import com.jxwk.auth.business.biz.AdminShiroBiz;
import com.jxwk.auth.business.dao.entity.SysResource;
import com.jxwk.auth.web.shiro.util.CollectionUtils;

/**
 * apache shiro 的公用授权类
 * 
 *
 */
public abstract class AuthorizationRealm extends AuthorizingRealm{

	@Autowired
	private AdminShiroBiz adminShiroBiz;
	
	private List<String> defaultPermission = new ArrayList<String>();
	
	/**
	 * 设置默认permission
	 * 
	 * @param defaultPermissionString permission 如果存在多个值，使用逗号","分割
	 */
	public void setDefaultPermissionString(String defaultPermissionString) {
		String[] perms = StringUtils.split(defaultPermissionString,",");
		CollectionUtils.addAll(defaultPermission, perms);
	}
	
	/**
	 * 设置默认permission
	 * 
	 * @param defaultPermission permission
	 */
	public void setDefaultPermission(List<String> defaultPermission) {
		this.defaultPermission = defaultPermission;
	}
	
	/**
	 * 
	 * 当用户进行访问链接时的授权方法
	 * 
	 */
	protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        
		  SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
	        ShiroUser model = principals.oneByType(ShiroUser.class);
	        //认证信息
//	        getAuthenticationCache()
	        //授权信息
//	        Cache<Object, AuthenticationInfo> caches = getAuthenticationCache();
			Assert.notNull(model, "找不到principals中的ShiroUser");
			List<SysResource> resources = adminShiroBiz.findResourceByRoleId(NumberUtils.toInt(model.getSysUser().getRoleId()));
			List<String> permissions = getPermsValue(resources);
			
			 //添加默认的permissions到permissions
	        if (CollectionUtils.isNotEmpty(defaultPermission)) {
	        	CollectionUtils.addAll(permissions, defaultPermission.iterator());
	        }
	        // 添加用户拥有的permission
	        Set<String> set = new HashSet<String>(permissions);
            if (!CollectionUtils.isEmpty(permissions)) {
                 // 权限加入AuthorizationInfo认证对象
                 info.setStringPermissions(set);
             }
			//info.addStringPermissions(permissions);
			// 添加用户拥有的role
			// info.addRoles(rolesList);

			model.setMenus(extractMenusFromResources(resources));
			// model.setAuthorizationInfo(authorizationInfo)

			return info;
	}
	
 
	
	public List<Menu> extractMenusFromResources(List<SysResource> list) {
		List<Menu> menus = new ArrayList<Menu>();
		Map<Integer,List<Menu>> tempMap= new HashMap<Integer,List<Menu>>();
		Menu menu =null;
		List<Menu> childList =null;
		for(SysResource resource:list){
			if(null != resource){
				
				if(resource.getType()==1){
					menu =new Menu(resource.getId(),resource.getName(),StringUtils.replace(resource.getUrl(), "**", ""),null);
					if(resource.getParentId()==0){
						menus.add(menu);
					}else{
						if(null==tempMap.get(resource.getParentId())){
							childList = new ArrayList<Menu>();
							 childList.add(menu);
							tempMap.put(resource.getParentId(), childList);
						}else{
							tempMap.get(resource.getParentId()).add(menu);
						}
					}
				}
			}
		}
		for(Menu ms :menus){
			if(tempMap.get(ms.getId())!=null){
				ms.setChildren(tempMap.get(ms.getId()));
			}
		}
		return menus;
	}
	
	
	private List<String> getPermsValue(List<SysResource> collection){
		 List<String> result = new ArrayList<String>();
		try {
			for (SysResource obj : collection) {
				if(null != obj){
					
					if(StringUtils.isNotBlank(obj.getPermission())){
						result.add(getValueForPattern(obj.getPermission()));
					}
				}
			}
		} catch (Exception e) {
		    e.printStackTrace();
			throw e;
		}
		return result;
	}

	/**
	 * 通过正则表达式获取字符串集合的值
	 * 
	 * @param obj 字符串集合
	 * @param regex 表达式
	 * 
	 * @return List
	 */
	private String getValueForPattern(String str){
		String res=null;
		Pattern pattern = Pattern.compile("perms\\[(.*?)\\]");
       Matcher matcher = pattern.matcher(str);
       while(matcher.find()){
       	res=matcher.group(1);
       }
       
		return res;
	}
}
