package com.jxwk.auth.web.interceptor;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import com.jxwk.auth.web.config.SystemConfig;
/**
 * 
 * 功能描述:系统模块拦截器 
 * 
 * @version 1.0.0
 * @author 徐大伟
 */
public class SystemInterceptor implements HandlerInterceptor{
    
    @Resource 
    private SystemConfig systemConfig;

    @Override
    public boolean preHandle(HttpServletRequest request,HttpServletResponse response,Object handler)throws Exception {
        HttpSession session = request.getSession(); 
        session.setAttribute("sys", systemConfig);
        return true; 
    }
    
    @Override
    public void postHandle(HttpServletRequest request,HttpServletResponse response,Object handler,ModelAndView modelAndView)
            throws Exception {
        
    }

    @Override
    public void afterCompletion(HttpServletRequest request,HttpServletResponse response,Object handler,Exception ex)
            throws Exception {
    } 
}
