package com.jxwk.auth.business.biz;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jxwk.auth.business.dao.SysResourceDao;
import com.jxwk.auth.business.dao.SysRoleDao;
import com.jxwk.auth.business.dao.entity.SysRole;
import com.jxwk.auth.business.pagination.Page;
import com.jxwk.auth.business.pagination.PageBuilder;
import com.jxwk.auth.business.pagination.PageRequest;
/**
 * 
 * 功能描述: 系统角色管理
 * 
 * @version 1.0.0
 * @author 徐大伟
 */
@Service("authSysRoleBiz")
public class SysRoleBiz {
	@Autowired
	private SysRoleDao sysRoleDao;
	@Autowired
	private SysResourceDao sysResourceDao;
	
	/**
	 * 根据角色名或用户类型获取角色集合
	 * @param name 角色名 模糊
	 * @param userType 用户类型
	 * @param pageRequest 分页请求对象
	 * @return 角色集合
	 */
	public Page<SysRole> findPageByNameAndUserType(String name,String userType,PageRequest pageRequest){
		List<SysRole> result =sysRoleDao.findSysRolesByNameAndUserType(name, userType, pageRequest.getOffset(),pageRequest.getPageSize());
		int total = sysRoleDao.countSysRolesByNameAndUserType(name, userType, pageRequest.getOffset(),pageRequest.getPageSize());
		
		return  PageBuilder.buildPage(pageRequest, result, total);
	}
	/**
	 * 查找所有资源并根据角色Id将已关联的资源  checked =1 
	 * @param roleId 
	 * @return 集合
	 */
	public List<Map<String,Object>> findResourcesByRoleId(Integer roleId){
		return sysRoleDao.findResourcesByRoleId(roleId);
	} 
	
	@Transactional
	public void saveRole(String name,String userType,List<String> resourceIds){
		SysRole role  = new SysRole();
		role.setName(name);
		role.setUserType(userType);
		sysRoleDao.saveRole(role);
		sysRoleDao.saveRoleMRessource(resourceIds, role.getId());
		
	}
	
	@Transactional
	public void updateRole(Integer roleId,String name,String userType,List<String> resourceIds){
		SysRole role  = new SysRole();
		role.setId(roleId);
		role.setName(name);
		sysRoleDao.updateRole(role);
		sysResourceDao.delRoleMRessourceByRoleId(roleId);
		sysRoleDao.saveRoleMRessource(resourceIds, role.getId());
		
	}
	
	public SysRole findOneById(int roleId){
		return sysRoleDao.findOneById(roleId);
	}
	/**
	 * 删除指定角色的记录及资源与角色中间表记录
	 * @param roleId
	 */
	@Transactional
	public void deleteRoleAndRoleResourceByRoleId(int roleId){
		sysRoleDao.delRoleByRoleId(roleId);
		sysResourceDao.delRoleMRessourceByRoleId(roleId);
	}
	

	/**
	 * 根据类型获取角色对象
	 * @return
	 */
	public List<SysRole> findRolesByUserTypes(List<String> userType){
		return sysRoleDao.findAllRole();
	}
}
