/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.auth.web.shiro.filter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.UrlPathHelper;

public class AdminContextInterceptor
extends HandlerInterceptorAdapter {
    private String[] excludeUrls;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String uri = AdminContextInterceptor.getURI(request);
        if (this.exclude(uri)) {
            return true;
        }
        Subject subject = SecurityUtils.getSubject();
        boolean pass = subject.isPermitted(uri);
        if (pass) {
            return true;
        }
        throw new Exception();
    }

    private boolean exclude(String uri) {
        if (this.excludeUrls != null) {
            for (String exc : this.excludeUrls) {
                if (!uri.endsWith(exc)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getURI(HttpServletRequest request) {
        UrlPathHelper helper = new UrlPathHelper();
        return helper.getOriginatingRequestUri(request);
    }

    public void setExcludeUrls(String[] excludeUrls) {
        this.excludeUrls = excludeUrls;
    }
}

