/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.auth.business.biz;

import com.jxwk.auth.business.dao.SysUserDao;
import com.jxwk.auth.business.dao.entity.SysUser;
import com.jxwk.auth.business.pagination.Page;
import com.jxwk.auth.business.pagination.PageBuilder;
import com.jxwk.auth.business.pagination.PageRequest;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="authSysUserBiz")
public class SysUserBiz {
    @Autowired
    private SysUserDao sysUserDao;

    public SysUser findByUsername(String userName) {
        if (null == userName || "".equals(userName)) {
            return null;
        }
        return this.sysUserDao.findByUserName(userName);
    }

    public int countSysUserByRoleId(int roleId) {
        return this.sysUserDao.countUserByRoleId(roleId);
    }

    public Page<Map<String, Object>> findUserList(String userName, String realName, String mobile, String userType, PageRequest pageRequest) {
        List<Map<String, Object>> list = this.sysUserDao.findUserList(userName, realName, mobile, userType, pageRequest.getOffset(), pageRequest.getPageSize());
        int total = this.sysUserDao.countUserList(userName, realName, mobile, userType, pageRequest.getOffset(), pageRequest.getPageSize());
        return PageBuilder.buildPage(pageRequest, list, total);
    }

    public int insert(SysUser user) {
        SysUser userTmp = this.sysUserDao.findByUserName(user.getUserName());
        if (userTmp != null) {
            return -1;
        }
        user.setPassword(this.encryptPwd(user.getPassword()));
        return this.sysUserDao.insert(user);
    }

    public boolean removeUser(Integer id) {
        return id != null && this.sysUserDao.removeUser(id) > 0;
    }

    public void updateUser(SysUser user) {
        this.sysUserDao.updateUser(user);
    }

    public SysUser selectByPrimaryKey(Integer id) {
        return this.sysUserDao.selectByPrimaryKey(id);
    }

    public int countUserByMobile(String mobile) {
        return this.sysUserDao.countUserByMobile(mobile);
    }

    public String updateRandomPwd(int id) {
        String npwd = this.getStringRandom(6);
        this.sysUserDao.updatePasswordById(this.encryptPwd(npwd), id);
        return npwd;
    }

    public int updatePwd(int userId, String newPwd) {
        return this.sysUserDao.updatePasswordById(this.encryptPwd(newPwd), userId);
    }

    private String getStringRandom(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = val + (char)(random.nextInt(26) + temp);
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    private String encryptPwd(String pwd) {
        return new SimpleHash("MD5", (Object)pwd).toHex();
    }

    public int checkAndSaveUser(SysUser user, String oldPassword) {
        String userName = user.getUserName();
        SysUser oldUser = this.sysUserDao.findByUserName(userName);
        if (null != oldPassword && !"".equals(oldPassword)) {
            String password = this.encryptPwd(user.getPassword());
            String pwd = this.encryptPwd(oldPassword);
            user.setPassword(password);
            if (!pwd.equals(oldUser.getPassword())) {
                return 6;
            }
        }
        String oldMobile = oldUser.getMobile();
        String newMobile = user.getMobile();
        int mobileCount = 0;
        if (!oldMobile.equals(newMobile) && (mobileCount = this.sysUserDao.countUserByMobile(newMobile)) > 0) {
            return 5;
        }
        this.sysUserDao.updateUser(user);
        return 0;
    }

    public List<Map<String, Object>> findUserListByType(String type) {
        return this.sysUserDao.findUserListByType(type);
    }
}

