/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.util.thrift;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftTSocket
extends TIOStreamTransport {
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TSocket.class.getName());
    private Socket socket_ = null;
    private String host_ = null;
    private int port_ = 0;

    public ThriftTSocket(Socket socket) throws TTransportException {
        this.socket_ = socket;
        try {
            this.socket_.setSoLinger(false, 0);
            this.socket_.setTcpNoDelay(true);
            this.socket_.setKeepAlive(true);
        }
        catch (SocketException sx) {
            LOGGER.warn("Could not configure socket.", (Throwable)sx);
        }
        if (this.isOpen()) {
            try {
                this.inputStream_ = new BufferedInputStream(this.socket_.getInputStream(), 4096);
                this.outputStream_ = new BufferedOutputStream(this.socket_.getOutputStream(), 4096);
            }
            catch (IOException iox) {
                this.close();
                throw new TTransportException(1, (Throwable)iox);
            }
        }
    }

    public ThriftTSocket(String host, int port) {
        this(host, port, 0, 0);
    }

    public ThriftTSocket(String host, int port, int connecttTimeout, int readTimeout) {
        this.host_ = host;
        this.port_ = port;
        this.connectTimeout = connecttTimeout;
        this.readTimeout = readTimeout;
        this.initSocket();
    }

    private void initSocket() {
        this.socket_ = new Socket();
        try {
            this.socket_.setSoLinger(false, 0);
            this.socket_.setTcpNoDelay(true);
            this.socket_.setKeepAlive(true);
            this.socket_.setSoTimeout(this.readTimeout);
        }
        catch (SocketException sx) {
            LOGGER.error("Could not configure socket.", (Throwable)sx);
        }
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        try {
            this.socket_.setSoTimeout(readTimeout);
        }
        catch (SocketException sx) {
            LOGGER.warn("Could not set socket timeout.", (Throwable)sx);
        }
    }

    public Socket getSocket() {
        if (this.socket_ == null) {
            this.initSocket();
        }
        return this.socket_;
    }

    public boolean isOpen() {
        if (this.socket_ == null) {
            return false;
        }
        return this.socket_.isConnected();
    }

    public void open() throws TTransportException {
        if (this.isOpen()) {
            throw new TTransportException(2, "Socket already connected.");
        }
        if (this.host_.length() == 0) {
            throw new TTransportException(1, "Cannot open null host.");
        }
        if (this.port_ <= 0) {
            throw new TTransportException(1, "Cannot open without port.");
        }
        if (this.socket_ == null) {
            this.initSocket();
        }
        try {
            this.socket_.connect(new InetSocketAddress(this.host_, this.port_), this.connectTimeout);
            this.inputStream_ = new BufferedInputStream(this.socket_.getInputStream(), 4096);
            this.outputStream_ = new BufferedOutputStream(this.socket_.getOutputStream(), 4096);
        }
        catch (IOException iox) {
            this.close();
            throw new TTransportException(1, (Throwable)iox);
        }
    }

    public void close() {
        super.close();
        if (this.socket_ != null) {
            try {
                this.socket_.close();
            }
            catch (IOException iox) {
                LOGGER.warn("Could not close socket.", (Throwable)iox);
            }
            this.socket_ = null;
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }
}

