/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.util.thrift;

import com.ync365.util.thrift.ServerInfo;
import com.ync365.util.thrift.ThriftBaseKeyedPooledObjectFactory;
import com.ync365.util.thrift.ThriftServiceClientProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ThriftServiceClientProxyFactory
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static Logger logger = LoggerFactory.getLogger(ThriftServiceClientProxy.class);
    private Class objectClass;
    private Object proxyClient;
    private String serviceInterface;
    private String serviceName;
    private String host;
    private int readTimeout = 0;
    private int connectTimeout = 0;
    private List<ServerInfo> clients = new ArrayList<ServerInfo>();
    private AtomicInteger count = new AtomicInteger(0);
    GenericKeyedObjectPool<ServerInfo, ThriftServiceClientProxy> pool;

    public void destroy() throws Exception {
        this.clients.clear();
    }

    public void afterPropertiesSet() throws Exception {
        String[] hosts;
        for (String address : hosts = this.host.split(",")) {
            String[] tmp2 = address.split(":");
            String ip = tmp2[0];
            int port = Integer.parseInt(tmp2[1]);
            this.serviceName = this.serviceInterface.substring(this.serviceInterface.lastIndexOf(".") + 1);
            ServerInfo serverInfo = new ServerInfo(ip, port, this.connectTimeout, this.readTimeout, this.serviceInterface, this.serviceName);
            this.clients.add(serverInfo);
        }
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setMinIdlePerKey(4);
        config.setMaxIdlePerKey(16);
        config.setMaxTotalPerKey(64);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(true);
        config.setTestWhileIdle(true);
        config.setMaxWaitMillis(10000L);
        config.setTimeBetweenEvictionRunsMillis(120000L);
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new ThriftBaseKeyedPooledObjectFactory(), config);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.objectClass = classLoader.loadClass(this.serviceInterface + "$Iface");
        this.proxyClient = Proxy.newProxyInstance(classLoader, new Class[]{this.objectClass}, new InvocationHandler(){

            /*
             * Exception decompiling
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    public ServerInfo getServerInfo() {
        int index = this.count.getAndIncrement() % this.clients.size();
        ServerInfo result = this.clients.get(index);
        return result;
    }

    public Object getObject() throws Exception {
        return this.proxyClient;
    }

    public Class getObjectType() {
        return this.objectClass;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

