/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.util.thrift;

import com.ync365.util.thrift.ThriftTSocket;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftServiceClientProxy {
    private static Logger logger = LoggerFactory.getLogger(ThriftServiceClientProxy.class);
    private String ip;
    private int port;
    private int readTimeout = 0;
    private int connectTimeout = 0;
    private volatile TProtocol protocol;
    private String serviceInterface;
    private String serviceName;
    private Class objectClass;
    private Object client;

    public ThriftServiceClientProxy(String ip, int port, int connectTimeout, int readTimeout, String serviceInterface, String serviceName) {
        this.ip = ip;
        this.port = port;
        this.serviceInterface = serviceInterface;
        this.serviceName = serviceName;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.init();
    }

    public void init() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.objectClass = classLoader.loadClass(this.serviceInterface + "$Iface");
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        ThriftTSocket transport = new ThriftTSocket(this.ip, this.port, this.connectTimeout, this.readTimeout);
        this.protocol = new TBinaryProtocol((TTransport)new TFramedTransport((TTransport)transport, 1638400000));
        try {
            transport.open();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            Class[] parameterTypes = new Class[]{TProtocol.class};
            Constructor<?> constructor = Class.forName(this.serviceInterface + "$Client").getConstructor(parameterTypes);
            Object[] arguments = new Object[]{new TMultiplexedProtocol(this.protocol, this.serviceName)};
            this.client = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void destory() {
        try {
            this.protocol.getTransport().close();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        this.protocol = null;
        this.client = null;
    }

    public boolean isOpen() {
        boolean result = false;
        try {
            result = this.protocol.getTransport().isOpen();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        boolean flag;
        block9: {
            flag = true;
            try {
                Socket s = new Socket();
                s.connect(new InetSocketAddress(this.ip, this.port), 1000);
                s.close();
                if (this.isOpen()) break block9;
                ThriftServiceClientProxy thriftServiceClientProxy = this;
                synchronized (thriftServiceClientProxy) {
                    if (!this.isOpen()) {
                        this.protocol.getTransport().open();
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("thrift server {}:{} check error.", (Object)this.ip, (Object)this.port);
                logger.warn(t.getMessage(), t);
                try {
                    this.protocol.getTransport().close();
                }
                finally {
                    flag = false;
                }
            }
        }
        return flag;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public TProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(TProtocol protocol) {
        this.protocol = protocol;
    }

    public Object getClient() {
        return this.client;
    }
}

